/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.servlet;

import com.atlassian.oauth2.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateServlet
extends HttpServlet {
    static final String URL = "/plugins/servlet/oauth2";
    public static final String MODULE_KEY = "com.atlassian.oauth2.oauth2-client-plugin:oauth2-plugin-templates";
    public static final String TEMPLATE_NAME = "OAuth.Configuration.display";
    private final LoginUriProvider loginUriProvider;
    private final SoyTemplateRenderer templateRenderer;
    private final RedirectsLoopPreventer loopPreventer;
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;

    public TemplateServlet(LoginUriProvider loginUriProvider, UserManager userManager, SoyTemplateRenderer templateRenderer, RedirectsLoopPreventer loopPreventer, WebSudoManager webSudoManager) {
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.templateRenderer = templateRenderer;
        this.loopPreventer = loopPreventer;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            if (this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey())) {
                response.setContentType("text/html;charset=UTF-8");
                this.templateRenderer.render((Appendable)response.getWriter(), MODULE_KEY, TEMPLATE_NAME, Collections.emptyMap());
            } else {
                String target = this.loginUriProvider.getLoginUriForRole(URI.create(URL), UserRole.SYSADMIN).toString();
                this.loopPreventer.preventRedirectsLoop(request, target);
                response.sendRedirect(target);
            }
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }
}

