/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.util.concurrent;

import com.atlassian.oauth2.client.util.concurrent.StripedMonitors;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class KeyedLocks<T> {
    private final StripedMonitors<T> stripes = new StripedMonitors();
    private final Map<T, AtomicInteger> monitors = new ConcurrentHashMap<T, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R executeWithLock(T key, Callable<R> task) throws Exception {
        AtomicInteger monitor;
        Object stripe;
        Object object = stripe = this.stripes.getMonitor(key);
        synchronized (object) {
            monitor = this.monitors.computeIfAbsent(key, k -> new AtomicInteger(0));
            monitor.incrementAndGet();
        }
        try {
            object = monitor;
            synchronized (object) {
                R r = task.call();
                return r;
            }
        }
        finally {
            Object object2 = stripe;
            synchronized (object2) {
                if (monitor.decrementAndGet() == 0) {
                    this.monitors.remove(key);
                }
            }
        }
    }

    public int size() {
        return this.monitors.size();
    }
}

