/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.lib.flow;

import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.lib.ClientConfigurationImpl;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlowRequestData
implements Serializable {
    private static final long serialVersionUID = -2394690665405404948L;
    private final ClientConfiguration clientConfiguration;
    private final String clientCallbackUrl;
    private final String flowRequestId;
    private final String state;

    public FlowRequestData(@Nonnull ClientConfiguration clientConfiguration, @Nonnull String clientCallbackUrl, @Nonnull String flowRequestId, @Nullable String state) {
        this.clientConfiguration = ClientConfigurationImpl.from(Objects.requireNonNull(clientConfiguration, "Client configuration cannot be null"));
        this.clientCallbackUrl = Objects.requireNonNull(clientCallbackUrl, "Client callback URL cannot be null");
        this.flowRequestId = Objects.requireNonNull(flowRequestId, "Flow request ID cannot be null");
        this.state = state;
    }

    @Nonnull
    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Nonnull
    public String getClientCallbackUrl() {
        return this.clientCallbackUrl;
    }

    @Nonnull
    public String getFlowRequestId() {
        return this.flowRequestId;
    }

    @Nonnull
    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowRequestData that = (FlowRequestData)o;
        return Objects.equals(this.clientConfiguration, that.clientConfiguration) && Objects.equals(this.clientCallbackUrl, that.clientCallbackUrl) && Objects.equals(this.flowRequestId, that.flowRequestId) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfiguration, this.clientCallbackUrl, this.flowRequestId, this.state);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientConfiguration", (Object)this.clientConfiguration).add("clientCallbackUrl", (Object)this.clientCallbackUrl).add("flowRequestId", (Object)this.flowRequestId).add("state", (Object)this.state).toString();
    }
}

