/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class InvalidResponseException
extends RuntimeException {
    private final ValidationReport validationReport;
    private String message;

    public InvalidResponseException(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            this.message = JsonValidationReportFormat.getInstance().apply(this.validationReport);
        }
        return this.message;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }
}

