/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.ImpersonatingAuthenticationProvider;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkEvent;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.mywork.client.service.ConfigService;
import com.atlassian.mywork.service.HostService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HostServiceImpl
implements InitializingBean,
DisposableBean,
HostService {
    private static final Logger log = LoggerFactory.getLogger(HostServiceImpl.class);
    private final ApplicationLinkService applicationLinkService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final InternalHostApplication internalHostApplication;
    private final ConfigService configService;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private volatile Option<ApplicationLink> activeHost = Option.none();
    private volatile Option<ApplicationLink> registeredHost = Option.none();
    private volatile boolean enabled = false;
    private final Predicate<ApplicationLink> isAvailableHost = new Predicate<ApplicationLink>(){

        public boolean apply(ApplicationLink appLink) {
            ApplicationLinkRequestFactory authenticatedRequestFactory = appLink.createAuthenticatedRequestFactory(Anonymous.class);
            try {
                ApplicationLinkRequest request = authenticatedRequestFactory.createRequest(Request.MethodType.GET, "/plugins/servlet/login-miniview");
                return (Boolean)request.executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, Boolean>(){

                    public Boolean handle(Response response) throws ResponseException {
                        return response.isSuccessful();
                    }
                });
            }
            catch (CredentialsRequiredException e) {
                log.error("Anonymously accessible resource requires authentication", (Throwable)e);
            }
            catch (ResponseException e) {
                log.debug("Failed to connect host " + appLink.getRpcUrl(), (Throwable)e);
            }
            return false;
        }
    };
    private final Predicate<ApplicationLink> hasSupportedAuth = new Predicate<ApplicationLink>(){

        public boolean apply(ApplicationLink appLink) {
            boolean supported = HostServiceImpl.this.isConfigured(appLink.getId(), ImpersonatingAuthenticationProvider.class);
            if (!supported) {
                log.debug("Cannot use '" + appLink.getDisplayUrl() + "' as notifications host: Only OAuth or Trusted Apps authentication are supported");
            }
            return supported;
        }
    };
    private final Predicate<ApplicationLink> updateRegistration = new Predicate<ApplicationLink>(){

        public boolean apply(ApplicationLink appLink) {
            Request request = Anonymous.createAnonymousRequest((ApplicationLink)appLink, (Request.MethodType)Request.MethodType.POST, (String)"/rest/mywork/1/client");
            request.setRequestContentType("text/plain");
            request.setRequestBody(HostServiceImpl.this.internalHostApplication.getId().get());
            try {
                request.execute();
                return true;
            }
            catch (ResponseException e) {
                log.debug("Registering with host '" + appLink.getDisplayUrl() + "' failed: " + e.getMessage());
                return false;
            }
        }
    };

    public HostServiceImpl(ApplicationLinkService applicationLinkService, AuthenticationConfigurationManager authenticationConfigurationManager, InternalHostApplication internalHostApplication, ConfigService configService, EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.applicationLinkService = applicationLinkService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.internalHostApplication = internalHostApplication;
        this.configService = configService;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.updateHostAvailability();
        }
    }

    public void resetHosts() {
        this.updateHostAvailability();
    }

    public void disable() {
        this.enabled = false;
        this.activeHost = Option.none();
        this.unregister(this.registeredHost);
        this.registeredHost = Option.none();
    }

    @EventListener
    public void applicationLinksChanged(ApplicationLinkEvent event) {
        if (event instanceof ApplicationLinkAddedEvent) {
            return;
        }
        this.updateHostAvailability();
    }

    public Option<ApplicationLink> getActiveHost() {
        return this.activeHost;
    }

    public Option<ApplicationLink> getRegisteredHost() {
        return this.registeredHost;
    }

    public Iterable<ApplicationLink> getAvailableHosts() {
        return Iterables.filter((Iterable)this.applicationLinkService.getApplicationLinks(), (Predicate)Predicates.and(this.hasSupportedAuth, this.isAvailableHost));
    }

    public void setSelectedHost(ApplicationId appId) {
        this.configService.setHost(appId != null ? appId.get() : null);
        Option<ApplicationLink> oldRegisteredHost = this.registeredHost;
        this.updateHostAvailability();
        if (oldRegisteredHost.isDefined() && !oldRegisteredHost.equals(this.registeredHost)) {
            this.unregister(oldRegisteredHost);
        }
    }

    private void unregister(Option<ApplicationLink> oldRegisteredHost) {
        oldRegisteredHost.map(Functions.forPredicate(this.updateRegistration));
    }

    private void updateHostAvailability() {
        if (this.enabled) {
            this.activeHost = this.findSelectedHost().filter(this.hasSupportedAuth);
            this.registeredHost = this.activeHost.filter(this.updateRegistration);
        }
    }

    private Option<ApplicationLink> findSelectedHost() {
        String appId = this.configService.getHost();
        if (appId != null) {
            return this.findUserSelectedHost(appId);
        }
        return this.findAutoSelectedHost();
    }

    private Option<ApplicationLink> findUserSelectedHost(String appId) {
        try {
            return Option.option((Object)this.applicationLinkService.getApplicationLink(new ApplicationId(appId)));
        }
        catch (TypeNotInstalledException e) {
            throw new RuntimeException(e);
        }
    }

    public Option<ApplicationLink> findAutoSelectedHost() {
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType.class);
        if (appLink == null) {
            log.debug("Could not select notifications host automatically: No Confluence application links are available");
        }
        return Option.option((Object)appLink);
    }

    private boolean isConfigured(ApplicationId applicationId, Class<? extends AuthenticationProvider> providerClass) {
        for (AuthenticationProviderPluginModule module : this.pluginAccessor.getEnabledModulesByClass(AuthenticationProviderPluginModule.class)) {
            Class moduleProviderClass = module.getAuthenticationProviderClass();
            if (!providerClass.isAssignableFrom(moduleProviderClass) || !this.authenticationConfigurationManager.isConfigured(applicationId, moduleProviderClass)) continue;
            return true;
        }
        return false;
    }
}

