/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.mywork.service.ClientRegistrationService;
import com.atlassian.mywork.service.HostService;
import com.atlassian.mywork.service.ServiceSelector;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="registration")
@Produces(value={"application/json"})
public class RegistrationResource {
    private static final Logger log = LoggerFactory.getLogger(RegistrationResource.class);
    private final ServiceSelector serviceSelector;
    private final ClientRegistrationService clientRegistrationService;
    private final HostService hostService;

    public RegistrationResource(ServiceSelector serviceSelector, ClientRegistrationService clientRegistrationService, HostService hostService) {
        this.serviceSelector = serviceSelector;
        this.clientRegistrationService = clientRegistrationService;
        this.hostService = hostService;
    }

    @GET
    @AnonymousAllowed
    public Response getRegistration(@QueryParam(value="appid") String appid) {
        ServiceSelector.Target target = this.serviceSelector.getTarget();
        if (target == ServiceSelector.Target.REMOTE || target == ServiceSelector.Target.AUTO) {
            for (ApplicationLink host : this.hostService.getActiveHost()) {
                if (!host.getId().get().equals(appid)) continue;
                return Response.ok((Object)this.clientRegistrationService.createRegistrations()).build();
            }
            log.debug("Registration failed: Request did not originate from an active host");
        } else {
            log.debug("Registration failed: Not acting as a client");
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

