/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.model;

import com.atlassian.mywork.rest.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.node.JsonNodeFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Registration
implements JsonObject {
    private static final ResourceBundle.Control CONTROL = new ResourceBundle.Control(){};
    @JsonProperty
    private final String application;
    @JsonProperty
    private final String appId;
    @JsonProperty
    private final String displayURL;
    @JsonProperty
    private final Map<String, Map<String, String>> i18n;
    @JsonProperty
    private final JsonNode actions;
    @JsonProperty
    private final Map<String, String> properties;
    @JsonProperty
    private final String templates;

    public Registration(RegistrationId id) {
        this(id.application, id.appId, null, new HashMap<String, Map<String, String>>(), (JsonNode)JsonNodeFactory.instance.objectNode(), new HashMap<String, String>(), null);
    }

    @JsonCreator
    public Registration(@JsonProperty(value="application") String application, @JsonProperty(value="appId") String appId, @JsonProperty(value="displayURL") String displayURL, @JsonProperty(value="i18n") Map<String, Map<String, String>> i18n, @JsonProperty(value="actions") JsonNode actions, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="templates") String templates) {
        this.application = application;
        this.appId = appId;
        this.displayURL = displayURL;
        this.actions = actions;
        this.i18n = i18n;
        this.properties = properties;
        this.templates = templates;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getApplication() {
        return this.application;
    }

    public String getDisplayURL() {
        return this.displayURL;
    }

    public Map<String, Map<String, String>> getI18n() {
        return Collections.unmodifiableMap(this.i18n);
    }

    public JsonNode getActions() {
        return this.actions;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getTemplates() {
        return this.templates;
    }

    public Map<String, String> getValues(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Locale> locales = CONTROL.getCandidateLocales("", locale);
        Collections.reverse(locales);
        for (Locale childLocale : locales) {
            Map<String, String> t = this.i18n.get(childLocale.toString());
            if (t == null) continue;
            map.putAll(t);
        }
        return map;
    }

    public RegistrationId getId() {
        return new RegistrationId(this.application, this.appId);
    }

    public boolean equals(Object object) {
        return EqualsBuilder.reflectionEquals((Object)object, (Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.application).append((Object)this.appId).append((Object)this.displayURL).append(this.i18n).append((Object)this.actions).append(this.properties).append((Object)this.templates).toHashCode();
    }

    public static class RegistrationId {
        public final String application;
        public final String appId;

        public RegistrationId(String application, String appId) {
            this.application = application;
            this.appId = appId;
        }

        public String toString() {
            return this.application + ":" + this.appId;
        }
    }
}

