/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.quartz;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.quartz.MultiTenantThreadPool;
import com.atlassian.multitenant.quartz.SystemThreadPoolController;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantQuartzSchedulerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Logger log = Logger.getLogger(MultiTenantQuartzSchedulerFactoryBean.class);
    private static final String SCHEDULER_NAME_PREFIX = "multitenant.";
    private Scheduler proxy;
    private MultiTenantComponentMap<Scheduler> map;
    private Properties quartzProperties;
    private List<Trigger> triggers;
    private Map<Object, Object> schedulerContextAsMap;
    private TriggerListener[] globalTriggerListeners;
    private int threadCount = 10;
    private int threadPriority = 4;

    public Object getObject() throws Exception {
        return this.proxy;
    }

    public Class getObjectType() {
        return Scheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        SystemThreadPoolController.getInstance().initialise(this.threadCount, this.threadPriority);
        this.map = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new QuartzSchedulerCreator()).setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_LOAD).construct();
        this.proxy = (Scheduler)MultiTenantContext.getFactory().createComponent(this.map, Scheduler.class);
    }

    public void destroy() throws Exception {
        for (Scheduler scheduler : this.map.getAll()) {
            if (!scheduler.isStarted()) continue;
            scheduler.shutdown();
        }
        SystemThreadPoolController.getInstance().shutdown();
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    public void setSchedulerContextAsMap(Map<Object, Object> schedulerContextAsMap) {
        this.schedulerContextAsMap = schedulerContextAsMap;
    }

    public void setGlobalTriggerListeners(TriggerListener[] globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    private void addTriggerToScheduler(Scheduler scheduler, Trigger trigger) throws SchedulerException {
        block4: {
            boolean triggerExists;
            boolean bl = triggerExists = scheduler.getTrigger(trigger.getName(), trigger.getGroup()) != null;
            if (!triggerExists) {
                if (trigger instanceof JobDetailAwareTrigger) {
                    JobDetail jobDetail = ((JobDetailAwareTrigger)trigger).getJobDetail();
                    this.addJobToScheduler(scheduler, jobDetail);
                }
                try {
                    scheduler.scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored"));
                }
            }
        }
    }

    private void addJobToScheduler(Scheduler scheduler, JobDetail jobDetail) throws SchedulerException {
        if (scheduler.getJobDetail(jobDetail.getName(), jobDetail.getGroup()) == null) {
            scheduler.addJob(jobDetail, true);
        }
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuartzSchedulerCreator
    implements MultiTenantCreator<Scheduler>,
    MultiTenantDestroyer<Scheduler> {
        private QuartzSchedulerCreator() {
        }

        public Scheduler create(Tenant tenant) {
            try {
                final StdSchedulerFactory factory = new StdSchedulerFactory();
                Properties mergedProps = new Properties();
                if (MultiTenantQuartzSchedulerFactoryBean.this.quartzProperties != null) {
                    CollectionUtils.mergePropertiesIntoMap((Properties)MultiTenantQuartzSchedulerFactoryBean.this.quartzProperties, (Map)mergedProps);
                }
                mergedProps.setProperty("org.quartz.scheduler.instanceName", MultiTenantQuartzSchedulerFactoryBean.SCHEDULER_NAME_PREFIX + tenant.getName());
                mergedProps.setProperty("org.quartz.threadPool.class", MultiTenantThreadPool.class.getName());
                factory.initialize(mergedProps);
                Scheduler scheduler = (Scheduler)MultiTenantContext.getManager().callForTenant(tenant, (Callable)new Callable<Scheduler>(){

                    @Override
                    public Scheduler call() throws Exception {
                        return factory.getScheduler();
                    }
                }, true);
                if (MultiTenantQuartzSchedulerFactoryBean.this.schedulerContextAsMap != null) {
                    scheduler.getContext().putAll(MultiTenantQuartzSchedulerFactoryBean.this.schedulerContextAsMap);
                }
                if (MultiTenantQuartzSchedulerFactoryBean.this.globalTriggerListeners != null) {
                    for (TriggerListener listener : MultiTenantQuartzSchedulerFactoryBean.this.globalTriggerListeners) {
                        scheduler.addGlobalTriggerListener(listener);
                    }
                }
                if (MultiTenantQuartzSchedulerFactoryBean.this.triggers != null) {
                    for (Trigger trigger : MultiTenantQuartzSchedulerFactoryBean.this.triggers) {
                        MultiTenantQuartzSchedulerFactoryBean.this.addTriggerToScheduler(scheduler, trigger);
                    }
                }
                scheduler.startDelayed(1000);
                return scheduler;
            }
            catch (SchedulerException se) {
                throw new RuntimeException("Error initialising scheduler", se);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error initialising scheduler", e);
            }
        }

        public void destroy(Tenant tenant, Scheduler instance) {
            try {
                if (instance.isStarted()) {
                    instance.shutdown();
                }
            }
            catch (SchedulerException se) {
                log.warn((Object)("Error shutting down scheduler for tenant: " + tenant.getName()));
            }
        }
    }
}

