/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.hibernate;

import com.atlassian.multitenant.CustomConfigHandler;
import com.atlassian.multitenant.hibernate.HibernateMultiTenantConfig;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateXmlCustomConfigHandler
implements CustomConfigHandler<HibernateMultiTenantConfig> {
    public Class<HibernateMultiTenantConfig> getBeanClass() {
        return HibernateMultiTenantConfig.class;
    }

    public HibernateMultiTenantConfig parse(Element element) {
        Class<?> driverClass;
        String driverClassName = element.elementText("driverClass");
        try {
            driverClass = Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        String databaseUrl = element.elementText("databaseUrl");
        String username = element.elementText("username");
        String password = element.elementText("password");
        int poolSize = Integer.parseInt(element.elementText("poolSize"));
        return new HibernateMultiTenantConfig(driverClass, databaseUrl, username, password, poolSize);
    }

    public void writeTo(Element element, HibernateMultiTenantConfig bean) {
        element.addElement("driverClass").setText(bean.getDriverClass().getName());
        element.addElement("username").setText(bean.getUsername());
        element.addElement("password").setText(bean.getPassword());
        element.addElement("poolSize").setText(Integer.toString(bean.getPoolSize()));
    }
}

