package com.atlassian.multitenant.osuser;

import com.atlassian.multitenant.CustomConfigHandler;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.XMLReader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * Store the osuser config in a byte array
 */
public class OsUserMultiTenantConfigHandler implements CustomConfigHandler<OsUserMultiTenantConfig>
{
    public Class<OsUserMultiTenantConfig> getBeanClass()
    {
        return OsUserMultiTenantConfig.class;
    }

    public OsUserMultiTenantConfig parse(final Element element)
    {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try
        {
            XMLWriter writer = new XMLWriter(os);
            writer.write(element);
        }
        catch (UnsupportedEncodingException uee)
        {
            // Why would this happen?
        }
        catch (IOException ioe)
        {
            // Ignore, not possible because we are writing to a byte array.
        }
        return new OsUserMultiTenantConfig(os.toByteArray());
    }

    public void writeTo(final Element element, final OsUserMultiTenantConfig bean)
    {
        SAXReader xmlReader = new SAXReader();
        try
        {
            Document document = xmlReader.read(new ByteArrayInputStream(bean.getOsUserXml()));
            for (Element child : (Iterable<Element>) document.getRootElement().elements())
            {
                element.add(child.createCopy());
            }
        }
        catch (DocumentException e)
        {
            // Shouldn't happen...
            throw new RuntimeException(e);
        }
    }
}
