package com.atlassian.multitenant.event;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Manager for peering event publishers
 */
public class DefaultPeeringEventPublisherManager implements PeeringEventPublisherManager
{
    private final Collection<PeeringEventPublisher> eventPublishers = new ArrayList<PeeringEventPublisher>();

    public void publish(Object event)
    {
        for (PeeringEventPublisher eventPublisher : eventPublishers)
        {
            eventPublisher.getTarget().publish(event);
        }
    }

    public void register(PeeringEventPublisher eventPublisher)
    {
        eventPublishers.add(eventPublisher);
    }
}
