/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.spring;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.spring.MultiTenantFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiTenantStatefulBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private static final String TARGET_BEAN_SUFFIX = ".multitenant.target";

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder beanDefinitionHolder, ParserContext parserContext) {
        String stateful = ((Attr)node).getValue();
        if (!Boolean.parseBoolean(stateful) || !MultiTenantContext.isEnabled()) {
            return beanDefinitionHolder;
        }
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String beanName = beanDefinitionHolder.getBeanName();
        String[] aliases = beanDefinitionHolder.getAliases();
        BeanDefinition existingDefinition = beanDefinitionHolder.getBeanDefinition();
        String className = existingDefinition.getBeanClassName();
        if (!(existingDefinition instanceof AbstractBeanDefinition)) {
            throw new IllegalArgumentException("Cannot make a non AbstractBeanDefinition stateful");
        }
        String newBeanName = beanName + TARGET_BEAN_SUFFIX;
        AbstractBeanDefinition abstractDefinition = (AbstractBeanDefinition)existingDefinition;
        for (String attribute : abstractDefinition.attributeNames()) {
            abstractDefinition.removeAttribute(attribute);
        }
        abstractDefinition.setScope("prototype");
        abstractDefinition.setAutowireCandidate(false);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)abstractDefinition, newBeanName), (BeanDefinitionRegistry)registry);
        RootBeanDefinition factoryDefinition = new RootBeanDefinition();
        factoryDefinition.setBeanClass(MultiTenantFactoryBean.class);
        MutablePropertyValues mpvs = new MutablePropertyValues();
        factoryDefinition.setPropertyValues(mpvs);
        mpvs.addPropertyValue("targetName", (Object)newBeanName);
        mpvs.addPropertyValue("implementation", (Object)className);
        Element parent = ((Attr)node).getOwnerElement();
        Attr attr = parent.getAttributeNodeNS("http://atlassian.com/schema/spring/multitenant", "lazy-loaded");
        if (attr != null && !Boolean.parseBoolean(attr.getValue())) {
            mpvs.addPropertyValue("lazyLoad", (Object)"false");
        }
        return new BeanDefinitionHolder((BeanDefinition)factoryDefinition, beanName, aliases);
    }
}

