/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.quartz;

import org.quartz.SchedulerConfigException;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemThreadPoolController {
    private static final Logger log = LoggerFactory.getLogger(SystemThreadPoolController.class);
    private static SystemThreadPoolController INSTANCE;
    private final SimpleThreadPool threadPool = new SimpleThreadPool();
    private final SystemThreadPoolWrapper wrapper = new SystemThreadPoolWrapper();

    private SystemThreadPoolController() {
        log.debug("New system thread pool controller created.");
    }

    public static synchronized SystemThreadPoolController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemThreadPoolController();
        }
        return INSTANCE;
    }

    public void initialise(int threadCount, int threadPriority) throws SchedulerConfigException {
        log.debug("Starting system thread pool controller");
        this.threadPool.setThreadCount(threadCount);
        this.threadPool.setThreadPriority(threadPriority);
        this.threadPool.setThreadNamePrefix("QuartzWorker");
        this.threadPool.initialize();
        log.debug("System thread pool controller started");
    }

    public void shutdown() {
        log.debug("Stopping system thread pool controller");
        this.threadPool.shutdown(false);
        log.debug("System thread pool controller stopped");
    }

    public ThreadPool getSystemThreadPool() {
        return this.wrapper;
    }

    private class SystemThreadPoolWrapper
    implements ThreadPool {
        private SystemThreadPoolWrapper() {
        }

        public boolean runInThread(Runnable runnable) {
            return SystemThreadPoolController.this.threadPool.runInThread(runnable);
        }

        public int blockForAvailableThreads() {
            return SystemThreadPoolController.this.threadPool.blockForAvailableThreads();
        }

        public void setInstanceId(String s) {
        }

        public void setInstanceName(String s) {
        }

        public void initialize() throws SchedulerConfigException {
            throw new UnsupportedOperationException("Do not initialise the system thread pool directly, use SystemThreadPoolController.initialise()");
        }

        public void shutdown(boolean b) {
            throw new UnsupportedOperationException("Do not shutdown the system thread pool directly, use SystemThreadPoolController.shutdown()");
        }

        public int getPoolSize() {
            return SystemThreadPoolController.this.threadPool.getPoolSize();
        }
    }
}

