/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.quartz;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.quartz.SystemThreadPoolController;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class MultiTenantThreadPool
implements ThreadPool {
    private final Tenant tenant = MultiTenantContext.getTenantReference().get();
    private final ThreadPool delegate = SystemThreadPoolController.getInstance().getSystemThreadPool();

    public boolean runInThread(Runnable runnable) {
        return this.delegate.runInThread((Runnable)new MultiTenantRunnable(runnable));
    }

    public int blockForAvailableThreads() {
        return this.delegate.blockForAvailableThreads();
    }

    public void initialize() throws SchedulerConfigException {
    }

    public void shutdown(boolean waitForJobsToComplete) {
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public void setInstanceId(String schedInstId) {
    }

    public void setInstanceName(String schedName) {
    }

    private class MultiTenantRunnable
    implements Runnable {
        private final Runnable runnableDelegate;

        private MultiTenantRunnable(Runnable runnableDelegate) {
            this.runnableDelegate = runnableDelegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MultiTenantContext.getTenantReference().set(MultiTenantThreadPool.this.tenant, false);
            try {
                this.runnableDelegate.run();
            }
            finally {
                MultiTenantContext.getTenantReference().remove();
            }
        }
    }
}

