/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.hibernate2;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.hibernate.HibernateMultiTenantConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import org.apache.log4j.Logger;

public class MultiTenantConnectionProvider
implements ConnectionProvider {
    private static final Logger log = Logger.getLogger(MultiTenantConnectionProvider.class);
    private final MultiTenantComponentMap<ConnectionProvider> map;
    private volatile Properties initialProperties;
    private volatile ConnectionProvider delegate;

    public MultiTenantConnectionProvider() {
        if (MultiTenantContext.getTenantReference().isSet()) {
            this.map = null;
        } else {
            ConnectionProviderCreator creator = new ConnectionProviderCreator();
            this.map = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)creator).setDestroyer((MultiTenantDestroyer)creator).setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_AFTER_STARTUP).construct();
        }
    }

    public void configure(Properties props) throws HibernateException {
        this.initialProperties = props;
        if (this.map == null) {
            this.delegate = new ConnectionProviderCreator().create(MultiTenantContext.getTenantReference().get());
        } else {
            this.map.initialiseAll();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.map == null) {
            return this.delegate.getConnection();
        }
        return ((ConnectionProvider)this.map.get()).getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (this.map == null) {
            this.delegate.closeConnection(conn);
        }
        ((ConnectionProvider)this.map.get()).closeConnection(conn);
    }

    public void close() throws HibernateException {
        if (this.map == null) {
            this.delegate.close();
        } else {
            for (ConnectionProvider provider : this.map.getAll()) {
                provider.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionProviderCreator
    implements MultiTenantCreator<ConnectionProvider>,
    MultiTenantDestroyer<ConnectionProvider> {
        private ConnectionProviderCreator() {
        }

        public ConnectionProvider create(Tenant tenant) {
            Properties properties = new Properties();
            for (String property : MultiTenantConnectionProvider.this.initialProperties.stringPropertyNames()) {
                properties.setProperty(property, MultiTenantConnectionProvider.this.initialProperties.getProperty(property));
            }
            properties.remove("hibernate.connection.provider_class");
            properties.remove("hibernate.connection.datasource");
            HibernateMultiTenantConfig config = (HibernateMultiTenantConfig)tenant.getConfig(HibernateMultiTenantConfig.class);
            properties.setProperty("hibernate.connection.driver_class", config.getDriverClass().getName());
            properties.setProperty("hibernate.connection.url", config.getDatabaseUrl());
            properties.setProperty("hibernate.connection.username", config.getUsername());
            properties.setProperty("hibernate.connection.password", config.getPassword());
            properties.setProperty("hibernate.c3p0.max_size", Integer.toString(config.getPoolSize()));
            try {
                return ConnectionProviderFactory.newConnectionProvider((Properties)properties);
            }
            catch (HibernateException e) {
                throw new RuntimeException("Error starting Hibernate provider", e);
            }
        }

        public void destroy(Tenant tenant, ConnectionProvider connectionProvider) {
            try {
                connectionProvider.close();
            }
            catch (HibernateException he) {
                log.warn((Object)("Error shutting down connection provider for tenant: " + tenant.getName()), (Throwable)he);
            }
        }
    }
}

