/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.jpa.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.WillClose;
import javax.persistence.PersistenceException;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

class LiquibaseSchemaUpgrader {
    private static final String CHANGE_LOG_TABLE = "MIG_DB_CHANGELOG";
    private static final String CHANGE_LOG_LOCK_TABLE = "MIG_DB_CHANGELOG_LOCK";

    LiquibaseSchemaUpgrader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void upgrade(@WillClose Connection connection, String changeLogPath) {
        try (Connection conn = connection;){
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor();
            try (Database database = LiquibaseSchemaUpgrader.createDatabase(conn);){
                Liquibase liquibase = new Liquibase(changeLogPath, (ResourceAccessor)resourceAccessor, database);
                liquibase.setIgnoreClasspathPrefix(true);
                liquibase.update(new Contexts(), new LabelExpression());
            }
        }
        catch (SQLException | LiquibaseException e) {
            throw new PersistenceException("Failed to update database schema", e);
        }
    }

    private static Database createDatabase(Connection c) throws DatabaseException {
        JdbcConnection liquibaseConnection = new JdbcConnection(c);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)liquibaseConnection);
        database.setDatabaseChangeLogTableName(CHANGE_LOG_TABLE);
        database.setDatabaseChangeLogLockTableName(CHANGE_LOG_LOCK_TABLE);
        return database;
    }
}

