/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.WorkItem;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.LockModeType;

@Singleton
public class WorkItemStore {
    private final EntityManagerTemplate tmpl;

    @Inject
    public WorkItemStore(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    public Long createWorkItem(WorkItem workItem) {
        this.tmpl.persist(workItem);
        return workItem.getItemId();
    }

    public WorkItem getAndLockWorkItemByRefId(String refId) {
        return this.tmpl.query(WorkItem.class, "select workitem from WorkItem workitem where workitem.refId=:refId").lock(LockModeType.PESSIMISTIC_WRITE).param("refId", (Object)refId).single();
    }

    public List<WorkItem> getBatchByType(String itemType, int batchSize) {
        return this.tmpl.query(WorkItem.class, "select workitem from WorkItem workitem where workitem.itemType=:itemType order by workitem.itemId asc").param("itemType", (Object)itemType).max(batchSize).list();
    }

    public void updateWorkItem(WorkItem workItem) {
        this.tmpl.merge(workItem);
    }

    public void deleteWorkItemByRefId(String refId) {
        this.tmpl.query("delete from WorkItem w where w.refId=:refId").param("refId", (Object)refId).flush(true).update();
    }

    public List<WorkItem> getWorkItemsByGroupId(String groupId, WorkItem.Status status) {
        return this.tmpl.query(WorkItem.class, "select w from WorkItem w where w.groupId=:groupId and w.status=:status").param("groupId", (Object)groupId).param("status", (Object)status).list();
    }

    public void deleteWorkItemsByGroupId(String groupId, WorkItem.Status status) {
        this.tmpl.query("delete from WorkItem w where w.groupId=:groupId and w.status=:status").param("groupId", (Object)groupId).param("status", (Object)status).update();
    }

    public boolean hasItemsInGroup(String groupId) {
        return this.tmpl.query(WorkItem.class, "select w from WorkItem w where w.groupId=:groupId").param("groupId", (Object)groupId).first().isPresent();
    }
}

