/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.LockModeType;

@Singleton
public class PlanStoreImpl
implements PlanStore {
    private final EntityManagerTemplate tmpl;

    @Inject
    PlanStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public Plan getPlan(String id) {
        return this.tmpl.query(Plan.class, "select plan from Plan plan where plan.id=:id").param("id", (Object)id).single();
    }

    @Override
    public Plan getPlanAndLock(String id) {
        return this.tmpl.query(Plan.class, "select plan from Plan plan where plan.id=:id").param("id", (Object)id).lock(LockModeType.PESSIMISTIC_WRITE).single();
    }

    @Override
    public List<Plan> getAllPlans() {
        return this.tmpl.query(Plan.class, "select plan from Plan plan order by plan.lastUpdate desc").list();
    }

    @Override
    public List<Plan> getAllPlansByCloudId(String cloudId) {
        return this.tmpl.query(Plan.class, "select plan from Plan plan where plan.cloudSite.cloudId=:cloudId").param("cloudId", (Object)cloudId).list();
    }

    @Override
    public Plan createPlan(Plan plan) {
        Instant now = Instant.now();
        plan.setCreatedTime(now);
        plan.setLastUpdate(now);
        this.tmpl.persist(plan);
        return plan;
    }

    @Override
    public void updatePlan(Plan plan) {
        plan.setLastUpdate(Instant.now());
        this.tmpl.merge(plan);
    }

    @Override
    public void removeTasks(Plan entity) {
        this.tmpl.query("delete Task task where task.plan.id=:planId").param("planId", (Object)entity.getId()).update();
        entity.setTasks(Collections.emptyList());
    }

    @Override
    public boolean hasPlans(ExecutionStatus ... statuses) {
        if (statuses.length == 0) {
            return this.tmpl.query(Integer.class, "select 1 from Plan plan").first().isPresent();
        }
        return this.tmpl.query(Integer.class, "select 1 from Plan plan where plan.progress.status in :status").param("status", Arrays.asList(statuses)).first().isPresent();
    }

    @Override
    public boolean planNameExists(String name) {
        return this.tmpl.query(Integer.class, "select 1 from Plan plan where plan.name=:name").param("name", (Object)name).first().isPresent();
    }
}

