/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.migration.agent.model.stats.AttachmentStats;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.store.ContentStatisticsStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.Tuple;

@ParametersAreNonnullByDefault
@Singleton
public class ContentStatisticsStoreImpl
implements ContentStatisticsStore {
    private static final String JPQL_ATTACHMENTS_STATS = "select sum(p.longval) as sum, avg(p.longval) as avg, max(p.longval) as max, min(p.longval) as min from Attachment a join a.properties p where p.name='FILESIZE'";
    private static final String JPQL_CONTENT_COUNT_BY_TYPE = "select count(c) as count, c.type as type, c.status as status from SpaceContent c where c.space is not null and c.creationDate is not null group by c.type, c.status";
    private static final String JPQL_SPACE_CONTENT_COUNT_BY_TYPE = "select count(c) as count, c.type as type, c.status as status, c.space.id as id from SpaceContent c where c.space is not null and c.creationDate is not null group by c.space.id, c.type, c.status";
    private static final String JPQL_SPACE_CONTENT_COUNT = "select count(c) as count, c.type as type, c.status as status, c.space.id as id from SpaceContent c where c.space.id in :spaceIds and c.creationDate is not null group by c.space.id, c.type, c.status";
    private static final String JPQL_SPACE_ATTACHMENT_STATS = "select a.space.id as spaceId, sum(p.longval) as sum, avg(p.longval) as avg, max(p.longval) as max, min(p.longval) as min from Attachment a join a.properties p where p.name='FILESIZE' group by a.space.id";
    private static final String JPQL_SPACE_ATTACHMENT_STATS_SELECTED = "select a.space.id as spaceId, sum(p.longval) as sum, avg(p.longval) as avg, max(p.longval) as max, min(p.longval) as min from Attachment a join a.properties p where p.name='FILESIZE' and a.space.id in :spaceIds group by a.space.id";
    private static final String JPQL_SPACE_ID_TO_KEY = "select s.id as id, s.key as key from Space s";
    private static final String JPQL_SPACE_ID_TO_KEY_SELECTED = "select s.id as id, s.key as key from Space s where s.key in :keys";
    private static final String CONTENT_TYPE_PAGE = ContentType.PAGE.getType().toUpperCase(Locale.ENGLISH);
    private static final String CONTENT_TYPE_BLOGPOST = ContentType.BLOG_POST.getType().toUpperCase(Locale.ENGLISH);
    private static final String CONTENT_TYPE_ATTACHMENT = ContentType.ATTACHMENT.getType().toUpperCase(Locale.ENGLISH);
    private final EntityManagerTemplate tmpl;

    @Inject
    public ContentStatisticsStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public ContentSummary loadContentSummary() {
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_CONTENT_COUNT_BY_TYPE).list();
        return ContentStatisticsStoreImpl.mapContentSummary(queryResult, this.loadAttachmentStats());
    }

    @Override
    public Collection<SpaceStats> loadSpaceStatistics() {
        Map<Long, AttachmentStats> attachmentStats = this.loadSpaceAttachmentStats();
        Map<Long, String> spaceIdToKeyMap = this.getSpaceIdToKeyMap();
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_SPACE_CONTENT_COUNT_BY_TYPE).list();
        return ContentStatisticsStoreImpl.mapSpaceStatistics(queryResult, attachmentStats, spaceIdToKeyMap);
    }

    @Override
    public Collection<SpaceStats> loadSpaceStatistics(Collection<String> spaceKeys) {
        if (spaceKeys.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Long, String> spaceIdToKeyMap = this.getSpaceIdToKeyMap(spaceKeys);
        if (spaceIdToKeyMap.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Long, AttachmentStats> attachmentStats = this.loadSpaceAttachmentStats(spaceIdToKeyMap.keySet());
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_SPACE_CONTENT_COUNT).param("spaceIds", spaceIdToKeyMap.keySet()).list();
        return ContentStatisticsStoreImpl.mapSpaceStatistics(queryResult, attachmentStats, spaceIdToKeyMap);
    }

    @Override
    public SpaceStats loadSpaceStatistics(String spaceKey) {
        return this.loadSpaceStatistics((Collection<String>)ImmutableList.of((Object)spaceKey)).stream().findFirst().orElseThrow(() -> new RuntimeException(String.format("Failed to get space %s statistics", spaceKey)));
    }

    @VisibleForTesting
    static ContentSummary mapContentSummary(List<Tuple> queryResult, @Nullable AttachmentStats attachmentStats) {
        Map<String, Long> contentCountByType = queryResult.stream().filter(tuple -> ContentStatisticsStoreImpl.isAttachment(tuple) || ContentStatisticsStoreImpl.isContentInCurrentStatus(tuple)).collect(Collectors.toMap(tuple -> (String)tuple.get("type"), tuple -> (Long)tuple.get("count"), Long::sum));
        long pagesCount = ContentStatisticsStoreImpl.orZero(contentCountByType.get(CONTENT_TYPE_PAGE));
        long blogPostsCount = ContentStatisticsStoreImpl.orZero(contentCountByType.get(CONTENT_TYPE_BLOGPOST));
        long attachmentCount = ContentStatisticsStoreImpl.orZero(contentCountByType.get(CONTENT_TYPE_ATTACHMENT));
        Map<String, Long> draftsCountByType = queryResult.stream().filter(tuple -> ContentStatus.DRAFT.getValue().equals(tuple.get("status"))).collect(Collectors.toMap(tuple -> (String)tuple.get("type"), tuple -> (Long)tuple.get("count")));
        long draftsCount = ContentStatisticsStoreImpl.orZero(draftsCountByType.get(CONTENT_TYPE_PAGE)) + ContentStatisticsStoreImpl.orZero(draftsCountByType.get(CONTENT_TYPE_BLOGPOST));
        return ContentSummary.builder().attachments(attachmentStats == null ? AttachmentStats.ZERO : attachmentStats).numberOfBlogs(blogPostsCount).numberOfDrafts(draftsCount).numberOfAttachments(attachmentCount).numberOfPages(pagesCount).build();
    }

    private static long orZero(@Nullable Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }

    private static double orZero(@Nullable Double value) {
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    private static AttachmentStats mapAttachmentStats(Tuple queryResult) {
        long sum = ContentStatisticsStoreImpl.orZero((Long)queryResult.get("sum"));
        double avg = ContentStatisticsStoreImpl.orZero((Double)queryResult.get("avg"));
        long max = ContentStatisticsStoreImpl.orZero((Long)queryResult.get("max"));
        long min = ContentStatisticsStoreImpl.orZero((Long)queryResult.get("min"));
        return AttachmentStats.builder().averageSize(Math.round(avg)).maximumSize(max).minimumSize(min).totalSize(sum).build();
    }

    private AttachmentStats loadAttachmentStats() {
        Tuple queryResult = this.tmpl.query(Tuple.class, JPQL_ATTACHMENTS_STATS).single();
        return ContentStatisticsStoreImpl.mapAttachmentStats(queryResult);
    }

    private Map<Long, AttachmentStats> loadSpaceAttachmentStats() {
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_SPACE_ATTACHMENT_STATS).list();
        return queryResult.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get("spaceId"), ContentStatisticsStoreImpl::mapAttachmentStats));
    }

    private Map<Long, AttachmentStats> loadSpaceAttachmentStats(Collection<Long> spaceIds) {
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_SPACE_ATTACHMENT_STATS_SELECTED).param("spaceIds", spaceIds).list();
        return queryResult.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get("spaceId"), ContentStatisticsStoreImpl::mapAttachmentStats));
    }

    @VisibleForTesting
    static Collection<SpaceStats> mapSpaceStatistics(List<Tuple> queryResult, Map<Long, AttachmentStats> attachmentStats, Map<Long, String> spaceIdToKeyMap) {
        return spaceIdToKeyMap.keySet().stream().map(spaceId -> {
            String spaceKey = (String)spaceIdToKeyMap.get(spaceId);
            List<Tuple> spaceQueryResult = queryResult.stream().filter(tuple -> ((Long)tuple.get("id")).equals(spaceId)).collect(Collectors.toList());
            return new SpaceStats(spaceKey, ContentStatisticsStoreImpl.mapContentSummary(spaceQueryResult, (AttachmentStats)attachmentStats.get(spaceId)));
        }).collect(Collectors.toList());
    }

    private Map<Long, String> getSpaceIdToKeyMap() {
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_SPACE_ID_TO_KEY).list();
        return queryResult.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get("id"), tuple -> (String)tuple.get("key")));
    }

    private Map<Long, String> getSpaceIdToKeyMap(Collection<String> spaceKeys) {
        List<Tuple> queryResult = this.tmpl.query(Tuple.class, JPQL_SPACE_ID_TO_KEY_SELECTED).param("keys", spaceKeys).list();
        return queryResult.stream().collect(Collectors.toMap(tuple -> (Long)tuple.get("id"), tuple -> (String)tuple.get("key")));
    }

    private static boolean isAttachment(Tuple row) {
        return CONTENT_TYPE_ATTACHMENT.equals(row.get("type"));
    }

    private static boolean isContentInCurrentStatus(Tuple row) {
        return ContentStatus.CURRENT.getValue().equals(row.get("status"));
    }
}

