/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.AttachmentMigration;
import com.atlassian.migration.agent.store.AttachmentMigrationCandidate;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.Page;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.Tuple;

@Singleton
public class AttachmentStoreImpl
implements AttachmentStore {
    private static final String SPACE_KEY = "spaceKey";
    private static final String CLOUD_ID_KEY = "cloudId";
    private final EntityManagerTemplate tmpl;

    @Inject
    public AttachmentStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public Page<AttachmentMigrationCandidate> getAttachmentsToMigrate(String cloudId, String spaceKey, int pageSize) {
        String query = "select attachment, m from Attachment attachment left join attachment.migrations m on m.cloudId=:cloudId join attachment.space s on s.key=:spaceKey order by attachment.id";
        return this.tmpl.query(Tuple.class, query).param(SPACE_KEY, (Object)spaceKey).param(CLOUD_ID_KEY, (Object)cloudId).page(pageSize, tuple -> new AttachmentMigrationCandidate((Attachment)tuple.get(0), (AttachmentMigration)tuple.get(1)));
    }

    @Override
    public long getAttachmentsToMigrateSize(String spaceKey) {
        String query = "select sum(property.longval) from ContentProperty property where property.content in (select a from Attachment a where a.space.key=:spaceKey )";
        Long size = this.tmpl.query(Long.class, query).param(SPACE_KEY, (Object)spaceKey).single();
        return size == null ? 0L : size;
    }

    @Override
    public long countAttachmentsBySpaceKey(String spaceKey) {
        String query = "select count(attachment) from Attachment attachment join attachment.space s on s.key=:spaceKey";
        Long size = this.tmpl.query(Long.class, query).param(SPACE_KEY, (Object)spaceKey).single();
        return size == null ? 0L : size;
    }
}

