/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.version;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.MarketplaceClient;
import com.atlassian.marketplace.client.MarketplaceClientFactory;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.AddonVersionsQuery;
import com.atlassian.marketplace.client.api.Addons;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
class MarketplaceVersionChecker {
    private static final Logger log = ContextLoggerFactory.getLogger(MarketplaceVersionChecker.class);
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final MarketplaceClient marketplaceClient;

    @Inject
    MarketplaceVersionChecker(MigrationAgentConfiguration migrationAgentConfiguration) {
        this(migrationAgentConfiguration, MarketplaceClientFactory.createMarketplaceClient((URI)migrationAgentConfiguration.getMarketplaceBaseUrl()));
    }

    @VisibleForTesting
    MarketplaceVersionChecker(MigrationAgentConfiguration migrationAgentConfiguration, MarketplaceClient marketplaceClient) {
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.marketplaceClient = marketplaceClient;
    }

    Optional<Boolean> checkIfThereIsNewerVersion(String pluginVersion) {
        String pluginKey = this.migrationAgentConfiguration.getPluginKey();
        try {
            Addons addons = this.marketplaceClient.addons();
            AddonVersionsQuery versionQuery = AddonVersionsQuery.builder().afterVersion(Option.option((Object)pluginVersion)).bounds(QueryBounds.limit((Option)Option.option((Object)1))).application(Option.option((Object)ApplicationKey.CONFLUENCE)).build();
            log.debug("Requesting versions of addon {} with query {}.", (Object)pluginKey, (Object)versionQuery);
            Page versions = addons.getVersions(pluginKey, versionQuery);
            log.debug("Found {} versions of addon {}", (Object)versions.totalSize(), (Object)pluginKey);
            return Optional.of(versions.size() > 0);
        }
        catch (MpacException ex) {
            log.warn("Failed to get plugin versions from Marketplace", (Throwable)ex);
            return Optional.empty();
        }
    }
}

