/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.user.CloudEditionCheckResponse;
import com.atlassian.migration.agent.service.user.DefaultUsersMigrationService;
import com.atlassian.migration.agent.service.user.GroupConflictsCheckRequest;
import com.atlassian.migration.agent.service.user.GroupsConflictCheckResponse;
import com.atlassian.migration.agent.service.user.UsersMigrationRequest;
import com.atlassian.migration.agent.service.user.UsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationStatusResponse;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;

@Singleton
@ParametersAreNonnullByDefault
public class RetryingUsersMigrationService
implements UsersMigrationService {
    private final UsersMigrationService wrapped;
    private final RetryPolicy retryPolicy;

    @Inject
    public RetryingUsersMigrationService(DefaultUsersMigrationService wrapped) {
        this.wrapped = wrapped;
        this.retryPolicy = RetryPolicyBuilder.policyForMigrationServices();
    }

    @Override
    public String initiateUsersAndGroupsMigration(String containerToken, UsersMigrationRequest usersAndGroups) {
        return (String)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.initiateUsersAndGroupsMigration(containerToken, usersAndGroups));
    }

    @Override
    public UsersMigrationStatusResponse getUsersAndGroupsMigrationProgress(String containerToken, String taskId) {
        return (UsersMigrationStatusResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.getUsersAndGroupsMigrationProgress(containerToken, taskId));
    }

    @Override
    public String startGroupConflictsCheck(String containerToken, GroupConflictsCheckRequest groupNamesCheckRequest) {
        return (String)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.startGroupConflictsCheck(containerToken, groupNamesCheckRequest));
    }

    @Override
    public GroupsConflictCheckResponse getGroupConflictsCheckStatus(String containerToken, String taskId) {
        return (GroupsConflictCheckResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.getGroupConflictsCheckStatus(containerToken, taskId));
    }

    @Override
    public CloudEditionCheckResponse getCloudEditionCheck(String containerToken, UsersMigrationRequest usersAndGroups) {
        return (CloudEditionCheckResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.getCloudEditionCheck(containerToken, usersAndGroups));
    }

    @Override
    public UsersMigrationStatusResponse cancelUsersAndGroupsMigration(String containerToken, String taskId) {
        return (UsersMigrationStatusResponse)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.wrapped.cancelUsersAndGroupsMigration(containerToken, taskId));
    }
}

