/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.ConfluenceImportExportTaskStatus;
import com.atlassian.migration.agent.service.SpaceImportContextDto;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class SpaceImportExecutor
implements QueueConsumer,
JobRunner {
    private static final String CONF_TASK_ID_JOB_PARAM = "confTaskId";
    private static final String STEP_ID_JOB_PARAM = "stepId";
    private static final StepType IMPORT_STEP_TYPE = StepType.CONFLUENCE_IMPORT;
    private static final Duration POLLING_PERIOD = Duration.ofSeconds(5L);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:import-progress-tracker");
    private static final Pattern SPACE_EXISTS_PATTERN = Pattern.compile("A space with key (.+) already exists.");
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceImportExecutor.class);
    private final ProgressTracker progressTracker;
    private final StepStore stepStore;
    private final SchedulerService schedulerService;
    private final StepSchedulerService stepSchedulerService;
    private final CloudSiteService cloudSiteService;
    private final MigrationPlatformService migrationPlatformService;
    private final PluginTransactionTemplate ptx;
    private final AppMigrationServiceClient appMigrationServiceClient;
    private final SpaceManager spaceManager;

    @Inject
    SpaceImportExecutor(ProgressTracker progressTracker, StepStore stepStore, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, CloudSiteService cloudSiteService, MigrationPlatformService migrationPlatformService, PluginTransactionTemplate ptx, SpaceManager spaceManager, AppMigrationServiceClient appMigrationServiceClient) {
        this.progressTracker = progressTracker;
        this.stepStore = stepStore;
        this.stepSchedulerService = stepSchedulerService;
        this.schedulerService = schedulerService;
        this.cloudSiteService = cloudSiteService;
        this.migrationPlatformService = migrationPlatformService;
        this.ptx = ptx;
        this.spaceManager = spaceManager;
        this.appMigrationServiceClient = appMigrationServiceClient;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(IMPORT_STEP_TYPE.name()).withConcurrencyLevel(1).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, IMPORT_STEP_TYPE, () -> this.scheduleStep(stepId, jobId));
    }

    @VisibleForTesting
    Optional<StepResult> scheduleStep(String stepId, String jobId) {
        String taskId = this.initiateConfluenceSpaceImport(stepId);
        ImmutableMap jobParams = ImmutableMap.of((Object)STEP_ID_JOB_PARAM, (Object)stepId, (Object)CONF_TASK_ID_JOB_PARAM, (Object)taskId);
        Schedule schedule = Schedule.forInterval((long)POLLING_PERIOD.toMillis(), (Date)new Date(System.currentTimeMillis() + 5000L));
        this.stepSchedulerService.scheduleStep(stepId, RUNNER_KEY, JobId.of((String)jobId), IMPORT_STEP_TYPE, (Map<String, Serializable>)jobParams, schedule);
        return Optional.empty();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_JOB_PARAM);
        String confTaskId = (String)request.getJobConfig().getParameters().get(CONF_TASK_ID_JOB_PARAM);
        this.stepSchedulerService.runScheduledStep(request.getJobId(), IMPORT_STEP_TYPE, stepId, () -> this.doProgressCheck(stepId, confTaskId));
        return null;
    }

    @VisibleForTesting
    String initiateConfluenceSpaceImport(String stepId) {
        log.info("Initiate confluence space import with stepId: {}", (Object)stepId);
        SpaceImportContextDto ctx = this.createSpaceImportContext(stepId);
        String containerToken = this.cloudSiteService.getByStepId(stepId).getContainerToken();
        ConfluenceImportExportTaskStatus response = this.migrationPlatformService.initiateConfluenceSpaceImport(containerToken, ctx);
        log.info("Initiated import task. Response: {}", (Object)response);
        return response.getId();
    }

    @VisibleForTesting
    Optional<StepResult> doProgressCheck(String stepId, String confTaskId) {
        SpaceImportContextDto spaceImportContextDto = this.createSpaceImportContext(stepId);
        String containerToken = this.cloudSiteService.getByStepId(stepId).getContainerToken();
        ConfluenceImportExportTaskStatus response = this.migrationPlatformService.getConfluenceSpaceImportProgress(containerToken, confTaskId, spaceImportContextDto);
        log.debug("Got progress for task {}: {}", (Object)confTaskId, (Object)response);
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)this.ptx.read(() -> this.stepStore.getStep(stepId)).getTask();
        if (!response.isComplete()) {
            this.updateAppMigrationContext(task, "selected");
            this.progressTracker.progress(stepId, response.getPercentageComplete(), "Importing to Confluence Cloud");
            return Optional.empty();
        }
        if (!response.isSuccessful()) {
            this.updateAppMigrationContext(task, "failed");
            return Optional.of(SpaceImportExecutor.getStepResultForFailure(response.getMessage()));
        }
        this.updateAppMigrationContext(task, "imported");
        return Optional.of(StepResult.succeeded("Migration complete"));
    }

    @VisibleForTesting
    static StepResult getStepResultForFailure(@Nullable String message) {
        if (message == null) {
            return StepResult.failed("Cloud import failed with no message");
        }
        Matcher matcher = SPACE_EXISTS_PATTERN.matcher(message);
        if (matcher.find()) {
            return StepResult.failed("Cloud site already has this space");
        }
        return StepResult.failed(String.format("Import to cloud failed. Message: %s", message));
    }

    private SpaceImportContextDto createSpaceImportContext(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        String mediaFileId = step.getConfig();
        if (StringUtils.isBlank((String)mediaFileId)) {
            throw new StepExecutionException("Received a blank media file ID. Process cannot proceed.");
        }
        if (!(step.getTask() instanceof ConfluenceSpaceTask)) {
            throw new StepExecutionException("Cannot proceed because task is not an instance of ConfluenceSpaceTask");
        }
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
        Space space = Optional.ofNullable(this.spaceManager.getSpace(task.getSpaceKey())).orElseThrow(() -> new StepExecutionException("Cannot proceed because can't find any space with spaceKey: " + task.getSpaceKey()));
        SpaceImportContextDto ctx = new SpaceImportContextDto(step.getPlan().getId(), task.getId(), mediaFileId, space.getId());
        return ctx;
    }

    private void updateAppMigrationContext(ConfluenceSpaceTask task, String status) {
        this.appMigrationServiceClient.addMapping(task.getPlan().getCloudSite().getCloudId(), task.getPlan().getId(), "confluence.spaces", (Map)ImmutableMap.of((Object)task.getSpaceKey(), (Object)status));
    }
}

