/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
public class AttachmentDataProvider {
    private final AttachmentManager attachmentManager;
    private final TransactionTemplate transactionTemplate;

    @Inject
    AttachmentDataProvider(AttachmentManager attachmentManager, TransactionTemplate transactionTemplate) {
        this.attachmentManager = attachmentManager;
        this.transactionTemplate = transactionTemplate;
    }

    AttachmentData getAttachmentData(long attachmentId) {
        return (AttachmentData)this.transactionTemplate.execute(() -> {
            Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
            if (attachment == null) {
                throw new AttachmentDataRetrievalException(String.format("Attachment %s is null", attachmentId));
            }
            if (attachment.getContainer() == null) {
                throw new AttachmentDataRetrievalException(String.format("Attachment's %s container is null", attachmentId));
            }
            AttachmentDao attachmentDao = this.attachmentManager.getAttachmentDao();
            try {
                InputStream attachmentStream = attachmentDao.getAttachmentData(attachment);
                return new AttachmentData(attachment.getFileName(), attachmentStream);
            }
            catch (AttachmentDataNotFoundException e) {
                throw new AttachmentDataRetrievalException(String.format("Could not get attachment %s data", attachmentId), e);
            }
            catch (IllegalArgumentException e) {
                throw new AttachmentDataRetrievalException(String.format("Attachment %s not found", attachmentId), e);
            }
        });
    }

    public static class AttachmentData
    implements AutoCloseable {
        private static final Logger log = ContextLoggerFactory.getLogger(AttachmentData.class);
        final String fileName;
        final InputStream inputStream;

        AttachmentData(String fileName, InputStream inputStream) {
            this.fileName = fileName;
            this.inputStream = inputStream;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                log.warn("Failed to close attachment input stream", (Throwable)e);
            }
        }
    }

    static class AttachmentDataRetrievalException
    extends RuntimeException {
        AttachmentDataRetrievalException(String message) {
            super(message);
        }

        AttachmentDataRetrievalException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

