/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import javax.annotation.Nullable;

public class StepResult {
    private final boolean isSuccess;
    private final boolean isStopped;
    private final String message;
    private final String result;
    private final Throwable e;

    private StepResult(boolean isSuccess, boolean isStopped, String message, String result, Throwable e) {
        this.isSuccess = isSuccess;
        this.isStopped = isStopped;
        this.message = message;
        this.result = result;
        this.e = e;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getResult() {
        return this.result;
    }

    @Nullable
    public Throwable getException() {
        return this.e;
    }

    public static StepResult failed(String message) {
        return new StepResult(false, false, message, null, null);
    }

    public static StepResult failed(String message, Throwable e) {
        return new StepResult(false, false, message, null, e);
    }

    public static StepResult stopped() {
        return new StepResult(false, true, null, null, null);
    }

    public static StepResult succeeded(String message) {
        return new StepResult(true, false, message, null, null);
    }

    public static StepResult succeeded(String message, String result) {
        return new StepResult(true, false, message, result, null);
    }
}

