/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
public abstract class BaseStepPlanningEngine<T extends Task>
implements StepPlanningEngine<T> {
    private final Class<T> taskType;
    private final Map<String, StepPlanningEngine.PercentRange> percentRangeMap;

    BaseStepPlanningEngine(Class<T> taskType, Collection<Pair<StepType, Integer>> percentAtEnd) {
        this.taskType = taskType;
        this.percentRangeMap = BaseStepPlanningEngine.calculatePercentRangeMap(percentAtEnd);
    }

    private static Map<String, StepPlanningEngine.PercentRange> calculatePercentRangeMap(Collection<Pair<StepType, Integer>> percentAtEnd) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int currentPercent = 0;
        for (Pair<StepType, Integer> entry : percentAtEnd) {
            int to;
            int from = currentPercent;
            currentPercent = to = currentPercent + (Integer)entry.getRight();
            builder.put((Object)((StepType)((Object)entry.getLeft())).name(), (Object)new StepPlanningEngine.PercentRange(from, to));
        }
        if (currentPercent != 100) {
            throw new IllegalArgumentException("Sum of all steps' percentages should be 100, current value " + currentPercent);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Optional<StepPlanningEngine.PercentRange> getStepPercentRange(Step step) {
        return Optional.ofNullable(this.percentRangeMap.get(step.getType()));
    }

    @Override
    public Class<T> getTaskType() {
        return this.taskType;
    }
}

