/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.SpaceDto;
import com.atlassian.migration.agent.dto.SpaceSearchResultDto;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Space;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.migration.agent.store.ConfluenceSpaceTaskStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class SpaceCatalogService {
    private final PluginTransactionTemplate ptx;
    private final SpaceStore spaceStore;
    private final ConfluenceSpaceTaskStore confluenceSpaceTaskStore;
    private final StatisticsService statisticsService;

    @Inject
    SpaceCatalogService(PluginTransactionTemplate ptx, SpaceStore spaceStore, ConfluenceSpaceTaskStore confluenceSpaceTaskStore, StatisticsService statisticsService) {
        this.ptx = ptx;
        this.spaceStore = spaceStore;
        this.confluenceSpaceTaskStore = confluenceSpaceTaskStore;
        this.statisticsService = statisticsService;
    }

    public SpaceSearchResultDto getSpaces(String cloudId, String query, SpaceTypeFilter spaceTypeFilter, int startIndex, int pageSize) {
        int totalSpaces = this.ptx.read(() -> this.spaceStore.getSpacesCount(query, spaceTypeFilter));
        List pagedSpaces = this.ptx.read(() -> this.spaceStore.getSpacesPaged(query, spaceTypeFilter, startIndex, pageSize));
        if (pagedSpaces.isEmpty()) {
            return new SpaceSearchResultDto(totalSpaces, startIndex, pageSize, Collections.emptyList());
        }
        List<String> spaceKeys = pagedSpaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map<String, ContentSummary> spaceKeyToSummary = this.statisticsService.loadSpaceStatistics(spaceKeys).stream().collect(Collectors.toMap(SpaceStats::getSpaceKey, SpaceStats::getSummary));
        Map spaceKeyToProgress = this.ptx.read(() -> this.confluenceSpaceTaskStore.getLatestSpaceProgress(cloudId, spaceKeys));
        Collection spaceDtos = pagedSpaces.stream().map(space -> this.spaceToDto((Space)space, spaceKeyToSummary, spaceKeyToProgress)).collect(Collectors.toList());
        return new SpaceSearchResultDto(totalSpaces, startIndex, pageSize, spaceDtos);
    }

    private SpaceDto spaceToDto(Space space, Map<String, ContentSummary> spaceKeyToSummary, Map<String, Progress> spaceKeyToProgress) {
        String spaceKey = space.getKey();
        ContentSummary spaceSummary = spaceKeyToSummary.getOrDefault(spaceKey, ContentSummary.ZERO);
        long estimationSeconds = MigrationTimeEstimationUtils.estimateSpaceMigrationTime(spaceSummary).getSeconds();
        return new SpaceDto(spaceKey, space.getId(), space.getName(), spaceSummary, Optional.ofNullable(spaceKeyToProgress.get(spaceKey)).map(ProgressDto::fromPlanEntity).orElse(null), estimationSeconds);
    }
}

