/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.ConfluenceImportExportTaskStatus;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.SpaceImportContextDto;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@ParametersAreNonnullByDefault
public class MigrationPlatformService {
    private static final String IMPORT_SPACE_PATH = "/confluence/import";
    private static final String IMPORT_SPACE_PROGRESS_PATH = "/confluence/import/{taskId}";
    private static final String GET_MEDIA_TOKEN_PATH = "/confluence/token";
    private static final String GET_SPACE_CONFLICTS_PATH = "/confluence/spaceconflicts";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final RetryPolicy retryPolicy;

    @Inject
    public MigrationPlatformService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor) {
        this(new HttpService(() -> MigrationPlatformService.buildHttpClient(userAgentInterceptor)), configuration, RetryPolicyBuilder.policyForMigrationServices());
    }

    @VisibleForTesting
    MigrationPlatformService(HttpService httpService, MigrationAgentConfiguration configuration) {
        this(httpService, configuration, RetryPolicyBuilder.policyForMigrationServices());
    }

    @VisibleForTesting
    MigrationPlatformService(HttpService httpService, MigrationAgentConfiguration configuration, RetryPolicy retryPolicy) {
        this.httpService = httpService;
        this.configuration = configuration;
        this.retryPolicy = retryPolicy;
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor) {
        return new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationServiceBaseUrl());
    }

    public ConfluenceImportExportTaskStatus initiateConfluenceSpaceImport(String containerToken, SpaceImportContextDto spaceImportContext) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilder().path(IMPORT_SPACE_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(spaceImportContext))).build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public ConfluenceImportExportTaskStatus getConfluenceSpaceImportProgress(String containerToken, String confTaskId, SpaceImportContextDto spaceImportContext) {
        Objects.requireNonNull(confTaskId);
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path(IMPORT_SPACE_PROGRESS_PATH).buildAndExpand(new Object[]{confTaskId}).toUriString()).addHeader("Accept", "application/json").post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(spaceImportContext))).build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public MediaClientToken getMediaToken(String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path(GET_MEDIA_TOKEN_PATH).toUriString()).addHeader("Accept", "application/json").post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)"")).build();
        return this.callJsonWithRetries(request, new TypeReference<MediaClientToken>(){});
    }

    public Set<SpaceConflict> getSpaceConflicts(String containerToken, Set<String> spaceKeys) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path(GET_SPACE_CONFLICTS_PATH).toUriString()).addHeader("Accept", "application/json").post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(ImmutableMap.of((Object)"spaceKeys", spaceKeys)))).build();
        return this.callJsonWithRetries(request, new TypeReference<SpaceConflictCheckResponse>(){}).spaceConflicts;
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callJson(request, bodyType));
    }

    @VisibleForTesting
    static class SpaceConflictCheckResponse {
        private Set<SpaceConflict> spaceConflicts;

        @JsonCreator
        SpaceConflictCheckResponse(@JsonProperty(value="spaceConflicts") Set<SpaceConflict> spaceConflicts) {
            this.spaceConflicts = spaceConflicts;
        }
    }
}

