/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.group;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.group.GroupNamesCheckContextProvider;
import com.atlassian.migration.agent.service.check.group.GroupNamesConflictChecker;
import com.atlassian.migration.agent.service.check.group.GroupNamesConflictContext;
import com.atlassian.migration.agent.service.check.group.GroupNamesConflictMapper;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.atlassian.user.GroupManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class GroupNamesConflictCheckRegistration
implements CheckRegistration<GroupNamesConflictContext> {
    private final GroupNamesConflictChecker checker;
    private final GroupNamesConflictMapper resultMapper;
    private final GroupNamesCheckContextProvider provider;
    private final ExecutorService executorService;
    private final AnalyticsEventBuilder analyticsEventBuilder;

    @Inject
    GroupNamesConflictCheckRegistration(CloudSiteService cloudSiteService, RetryingUsersMigrationService usersMigrationService, GroupManager groupManager, AnalyticsEventBuilder analyticsEventBuilder) {
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.executorService = Executors.newCachedThreadPool();
        this.checker = new GroupNamesConflictChecker(this.executorService, cloudSiteService, usersMigrationService);
        this.resultMapper = new GroupNamesConflictMapper();
        this.provider = new GroupNamesCheckContextProvider(groupManager);
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdownNow();
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.GROUP_NAMES_CONFLICT;
    }

    @Override
    public Checker<GroupNamesConflictContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<GroupNamesConflictContext> getCheckContextProvider() {
        return this.provider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.resultMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(CheckResult checkResult, long totalTime) {
        return this.analyticsEventBuilder.buildPreflightGroupNamesConflict(checkResult.success, GroupNamesConflictChecker.retrieveDuplicateGroupNames(checkResult.details), totalTime);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "cloudExistantGroupsCheck";
    }
}

