/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.group;

import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.group.GroupNamesConflictContext;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class GroupNamesCheckContextProvider
implements CheckContextProvider<GroupNamesConflictContext> {
    private static final String CLOUD_ID_KEY = "cloudId";
    private final GroupManager groupManager;

    @Inject
    GroupNamesCheckContextProvider(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public GroupNamesConflictContext apply(Map<String, Object> parameters) {
        String cloudId = (String)parameters.get(CLOUD_ID_KEY);
        if (cloudId == null) {
            throw new IllegalArgumentException("Unable to retrieve cloudId in parameters");
        }
        try {
            List<String> groupNames = StreamSupport.stream(this.groupManager.getGroups().spliterator(), false).map(Entity::getName).collect(Collectors.toList());
            return new GroupNamesConflictContext(cloudId, groupNames);
        }
        catch (EntityException e) {
            throw new RuntimeException(String.format("Unable to build context for group names conflict, %s", e.getMessage()), e);
        }
    }
}

