/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.okhttp;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.okhttp.ErrorCode;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.IOHttpException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class RetryPolicyBuilder {
    private static final Logger log = ContextLoggerFactory.getLogger(RetryPolicyBuilder.class);
    private RetryPolicy policy;
    private Collection<Predicate<Throwable>> predicates = new ArrayList<Predicate<Throwable>>();

    private RetryPolicyBuilder(RetryPolicy policy) {
        this.policy = policy;
    }

    public static RetryPolicy policyForMigrationServices() {
        return RetryPolicyBuilder.defaultPolicy().withErrorCode(ErrorCode.GENERIC, ErrorCode.UNHANDLED_COMMUNICATION_ERROR_WITH_DOWNSTREAM_SERVER, ErrorCode.FAILED_TO_START_MIGRATION).retryOn(Collections.singletonList(IOHttpException.class)).build();
    }

    public static RetryPolicyBuilder defaultPolicy() {
        return new RetryPolicyBuilder(new RetryPolicy().withMaxRetries(5).withBackoff(1L, 20L, TimeUnit.SECONDS)).withStatusCode(HttpStatus.Series.SERVER_ERROR);
    }

    public static RetryPolicyBuilder createFromBase(RetryPolicy baseRetryPolicy) {
        return new RetryPolicyBuilder(baseRetryPolicy);
    }

    public RetryPolicyBuilder withStatusCode(Integer ... allowRetryCodes) {
        return this.withStatusCode(Stream.of(allowRetryCodes).collect(Collectors.toSet()));
    }

    public RetryPolicyBuilder withStatusCode(Set<Integer> retryStatusCodes) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                Integer statusCode = ((HttpServiceException)exception).getStatusCode();
                return retryStatusCodes.contains(statusCode);
            }
            return false;
        });
        return this;
    }

    public RetryPolicyBuilder withErrorCode(ErrorCode ... retryErrorCodes) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                Integer errorCode = ((HttpServiceException)exception).getErrorCode();
                return Arrays.stream(retryErrorCodes).map(ErrorCode::getCode).anyMatch(code -> code.equals(errorCode));
            }
            return false;
        });
        return this;
    }

    public RetryPolicy build() {
        this.policy.retryIf((o, exception) -> this.evaluatePredicates((Throwable)exception));
        return this.policy;
    }

    private boolean evaluatePredicates(Throwable exception) {
        return !this.predicates.isEmpty() && this.predicates.stream().anyMatch(predicate -> predicate.test(exception));
    }

    public RetryPolicyBuilder retryOn(List<Class<? extends Throwable>> asList) {
        this.policy.retryOn(asList);
        return this;
    }

    public RetryPolicyBuilder retryOn(Class<? extends Throwable> exceptionClass) {
        this.policy.retryOn(exceptionClass);
        return this;
    }

    public RetryPolicyBuilder withPredicate(Predicate<Throwable> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    public RetryPolicyBuilder withStatusCode(HttpStatus.Series statusSeries) {
        this.predicates.add(exception -> {
            if (exception instanceof HttpServiceException) {
                int statusCode = ((HttpServiceException)exception).getStatusCode();
                try {
                    return HttpStatus.Series.valueOf((int)statusCode) == statusSeries;
                }
                catch (IllegalArgumentException e) {
                    log.warn("Unknown HTTP code: {}", (Object)statusCode);
                    return false;
                }
            }
            return false;
        });
        return this;
    }
}

