/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.okhttp;

import com.atlassian.migration.agent.okhttp.HttpServiceErrorHandler;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.IOHttpException;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DefaultHttpServiceErrorHandler
implements HttpServiceErrorHandler {
    @Override
    public void accept(Response response) {
        int statusCode = response.code();
        ResponseBody body = response.body();
        try {
            String serverMessage = body == null ? "" : body.string();
            String message = statusCode >= 400 && statusCode < 500 ? "Bad request." : "Internal error in downstream service.";
            throw new HttpServiceException(String.format("%s Status code: %d, message: %s", message, statusCode, serverMessage), statusCode);
        }
        catch (IOException e) {
            throw new IOHttpException("Failed to read response body", e);
        }
    }
}

