/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto;

import com.atlassian.migration.agent.dto.CloudSiteDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.TaskDto;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.util.CollectionUtils;

public class PlanDto {
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String checkExecutionId;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final Instant createdTime;
    @JsonProperty
    private final Instant lastUpdate;
    @JsonProperty
    private final CloudSiteDto cloudSite;
    @JsonProperty
    private final List<TaskDto> tasks;
    @JsonProperty
    private final ProgressDto progress;

    @JsonCreator
    public PlanDto(@JsonProperty(value="id") String id, @JsonProperty(value="checkExecutionId") String checkExecutionId, @JsonProperty(value="name") String name, @JsonProperty(value="createdTime") Instant createdTime, @JsonProperty(value="lastUpdate") Instant lastUpdate, @JsonProperty(value="cloudSite") CloudSiteDto cloudSite, @JsonProperty(value="tasks") List<TaskDto> tasks, @JsonProperty(value="progress") ProgressDto progress) {
        this.id = id;
        this.checkExecutionId = checkExecutionId;
        this.name = name;
        this.createdTime = createdTime;
        this.lastUpdate = lastUpdate;
        this.cloudSite = cloudSite;
        this.tasks = Collections.unmodifiableList(tasks);
        this.progress = progress;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getCheckExecutionId() {
        return this.checkExecutionId;
    }

    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    public CloudSiteDto getCloudSite() {
        return this.cloudSite;
    }

    public List<TaskDto> getTasks() {
        return this.tasks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ProgressDto getProgress() {
        return this.progress;
    }

    public static class Builder {
        private String id;
        private String checkExecutionId;
        private String name;
        private Instant createdTime;
        private Instant lastUpdate;
        private CloudSiteDto cloudSite;
        private List<TaskDto> tasks = new ArrayList<TaskDto>();
        private ProgressDto progress;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder checkExecutionId(String checkExecutionId) {
            this.checkExecutionId = checkExecutionId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder lastUpdate(Instant lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public Builder cloudSite(CloudSiteDto cloudSite) {
            this.cloudSite = cloudSite;
            return this;
        }

        public Builder task(TaskDto task) {
            this.tasks.add(task);
            return this;
        }

        public Builder tasks(List<TaskDto> tasks) {
            if (CollectionUtils.isEmpty(tasks)) {
                return this;
            }
            this.tasks = Collections.unmodifiableList(tasks);
            return this;
        }

        public Builder progress(ProgressDto progress) {
            this.progress = progress;
            return this;
        }

        public PlanDto build() {
            return new PlanDto(this.id, this.checkExecutionId, this.name, this.createdTime, this.lastUpdate, this.cloudSite, this.tasks, this.progress);
        }
    }
}

