/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.web;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.cloud.NonceService;
import com.atlassian.migration.agent.service.impl.DetectedUserEmailAnalyticsService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@WebSudoRequired
public class SaveCloudSiteAction
extends ConfluenceActionSupport {
    private static final String NONCE_ERROR_CODE = "nonceError";
    private static final String AUTH_ERROR_CODE = "authError";
    private String cloudUrl;
    private String cloudId;
    private String containerToken;
    private String nonce;
    private String cloudEdition;
    private final NonceService nonceService;
    private final CloudSiteService cloudSiteService;
    private final LegalService legalService;
    private final DetectedUserEmailAnalyticsService detectedUserEmailAnalyticsService;

    SaveCloudSiteAction(NonceService nonceService, CloudSiteService cloudSiteService, LegalService legalService, DetectedUserEmailAnalyticsService detectedUserEmailAnalyticsService) {
        this.nonceService = nonceService;
        this.cloudSiteService = cloudSiteService;
        this.legalService = legalService;
        this.detectedUserEmailAnalyticsService = detectedUserEmailAnalyticsService;
    }

    public String execute() {
        if (Stream.of(this.cloudUrl, this.cloudId, this.containerToken, this.nonce).anyMatch(Objects::isNull)) {
            return AUTH_ERROR_CODE;
        }
        if (!this.nonceService.validateAndDeleteNonce(this.nonce)) {
            return NONCE_ERROR_CODE;
        }
        Optional<Edition> edition = Optional.ofNullable(this.cloudEdition).map(s -> Edition.getByKey((String)this.cloudEdition));
        this.cloudSiteService.createOrUpdate(this.cloudId, this.cloudUrl, this.containerToken, edition);
        this.detectedUserEmailAnalyticsService.triggerForCloudId(this.cloudId);
        this.legalService.rememberLegalOptIn();
        return "success";
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public void setContainerToken(String containerToken) {
        this.containerToken = containerToken;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setCloudEdition(String cloudEdition) {
        this.cloudEdition = cloudEdition;
    }
}

