/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.migration.agent.entity.Space;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class SpaceStore {
    private final EntityManagerTemplate tmpl;
    private static final Map<SpaceTypeFilter, String> spaceFilterToType = ImmutableMap.of((Object)((Object)SpaceTypeFilter.PERSONAL), (Object)SpaceType.PERSONAL.toString(), (Object)((Object)SpaceTypeFilter.SITE), (Object)SpaceType.GLOBAL.toString());

    @Inject
    public SpaceStore(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    public int getSpacesCount(String nameQuery, SpaceTypeFilter spaceTypeFilter) {
        String query = "select count(*) from Space s" + this.whereClause(nameQuery, spaceTypeFilter);
        QueryBuilder<Long> builder = this.tmpl.query(Long.class, query);
        this.queryParam(builder, nameQuery);
        return builder.single().intValue();
    }

    public List<Space> getSpacesPaged(String nameQuery, SpaceTypeFilter spaceTypeFilter, int startIndex, int pageSize) {
        String query = "from Space s" + this.whereClause(nameQuery, spaceTypeFilter) + " order by s.key";
        QueryBuilder<Space> builder = this.tmpl.query(Space.class, query);
        this.queryParam(builder, nameQuery);
        return builder.first(startIndex).max(pageSize).list();
    }

    private String whereClause(String nameQuery, SpaceTypeFilter spaceTypeFilter) {
        if (StringUtils.isEmpty((CharSequence)nameQuery) && spaceTypeFilter == SpaceTypeFilter.ALL) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" where ");
        if (StringUtils.isNotEmpty((CharSequence)nameQuery)) {
            sb.append("s.name like :nameQuery");
        }
        if (spaceTypeFilter != SpaceTypeFilter.ALL) {
            if (StringUtils.isNotEmpty((CharSequence)nameQuery)) {
                sb.append(" and ");
            }
            sb.append("s.type = '").append(spaceFilterToType.get((Object)spaceTypeFilter)).append("'");
        }
        return sb.toString();
    }

    private void queryParam(QueryBuilder builder, String nameQuery) {
        if (StringUtils.isNotEmpty((CharSequence)nameQuery)) {
            builder.param("nameQuery", (Object)("%" + nameQuery + "%"));
        }
    }
}

