/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.agent.service.user.CloudEditionCheckResponse;
import com.atlassian.migration.agent.service.user.GroupConflictsCheckRequest;
import com.atlassian.migration.agent.service.user.GroupsConflictCheckResponse;
import com.atlassian.migration.agent.service.user.MigrationResponse;
import com.atlassian.migration.agent.service.user.UsersMigrationRequest;
import com.atlassian.migration.agent.service.user.UsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationStatusResponse;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@ParametersAreNonnullByDefault
class DefaultUsersMigrationService
implements UsersMigrationService {
    private static final String USERS_TASK_PATH = "/{taskId}";
    private static final String GROUPS_PATH = "/groupsconflict";
    private static final String GROUPS_TASK_PATH = "/groupsconflict/{taskId}";
    private static final String CLOUD_EDITION_PATH = "/cloudedition";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;

    @Inject
    public DefaultUsersMigrationService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor) {
        this(new HttpService(() -> DefaultUsersMigrationService.buildHttpClient(userAgentInterceptor), new ServiceErrorCodeHandler()), configuration);
    }

    @VisibleForTesting
    DefaultUsersMigrationService(HttpService httpService, MigrationAgentConfiguration configuration) {
        this.httpService = httpService;
        this.configuration = configuration;
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor) {
        return new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getUserMigrationServiceBaseUrl());
    }

    @Override
    public String initiateUsersAndGroupsMigration(String containerToken, UsersMigrationRequest usersAndGroups) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilder().toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(usersAndGroups))).build();
        return this.httpService.callJson((Request)request, new TypeReference<MigrationResponse>(){}).taskId;
    }

    @Override
    public UsersMigrationStatusResponse getUsersAndGroupsMigrationProgress(String containerToken, String taskId) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilder().path(USERS_TASK_PATH).buildAndExpand(new Object[]{taskId}).toUriString()).get().build();
        return this.httpService.callJson(request, new TypeReference<UsersMigrationStatusResponse>(){});
    }

    @Override
    public String startGroupConflictsCheck(String containerToken, GroupConflictsCheckRequest groupNamesCheckRequest) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilder().path(GROUPS_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(groupNamesCheckRequest))).build();
        return this.httpService.callJson((Request)request, new TypeReference<MigrationResponse>(){}).taskId;
    }

    @Override
    public GroupsConflictCheckResponse getGroupConflictsCheckStatus(String containerToken, String taskId) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilder().path(GROUPS_TASK_PATH).buildAndExpand(new Object[]{taskId}).toUriString()).get().build();
        return this.httpService.callJson(request, new TypeReference<GroupsConflictCheckResponse>(){});
    }

    @Override
    public CloudEditionCheckResponse getCloudEditionCheck(String containerToken, UsersMigrationRequest usersAndGroups) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilder().path(CLOUD_EDITION_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(usersAndGroups))).build();
        return this.httpService.callJson(request, new TypeReference<CloudEditionCheckResponse>(){});
    }
}

