/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.export.SpaceNoAttachmentsXmlExporter;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.ServiceInitializeException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportPostProcessor;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class SpaceExportExecutor
implements QueueConsumer,
JobRunner {
    private static final String STEP_ID_PARAMS_KEY = "stepId";
    private static final String STEP_CONFIG_PARAMS_KEY = "stepConfig";
    private static final StepType EXPORT_STEP_TYPE = StepType.CONFLUENCE_EXPORT;
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:export-executor");
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportExecutor.class);
    private final SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter;
    private final StepSchedulerService stepSchedulerService;
    private final SchedulerService schedulerService;
    private final ExportDirManager exportDirManager;
    private final BootstrapManager bootstrapManager;
    private final AttachmentService attachmentService;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    private final SpaceExportPostProcessor spaceExportPostProcessor;

    @Inject
    SpaceExportExecutor(SpaceNoAttachmentsXmlExporter spaceNoAttachmentsXmlExporter, StepSchedulerService stepSchedulerService, SchedulerService schedulerService, ExportDirManager exportDirManager, BootstrapManager bootstrapManager, AttachmentService attachmentService, StepStore stepStore, PluginTransactionTemplate ptx, SpaceExportPostProcessor spaceExportPostProcessor) {
        this.spaceNoAttachmentsXmlExporter = spaceNoAttachmentsXmlExporter;
        this.schedulerService = schedulerService;
        this.stepSchedulerService = stepSchedulerService;
        this.bootstrapManager = bootstrapManager;
        this.exportDirManager = exportDirManager;
        this.attachmentService = attachmentService;
        this.stepStore = stepStore;
        this.ptx = ptx;
        this.spaceExportPostProcessor = spaceExportPostProcessor;
    }

    @PostConstruct
    public void postConstruct() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
        File tempDirFilePath = new File(this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir"));
        boolean createTempDirResult = tempDirFilePath.mkdirs();
        log.debug("Created temporary directory for export, call return {}", (Object)createTempDirResult);
        if (!tempDirFilePath.exists()) {
            log.error("Failed to configure temporary directory from path property {}.", (Object)"webwork.multipart.saveDir");
            throw new ServiceInitializeException("Failed to configure temporary directory from path property webwork.multipart.saveDir");
        }
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(EXPORT_STEP_TYPE.name()).withConcurrencyLevel(1).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, EXPORT_STEP_TYPE, () -> {
            String stepConfig = this.ptx.read(() -> this.stepStore.getStep(stepId).getConfig());
            ImmutableMap jobParams = ImmutableMap.of((Object)STEP_CONFIG_PARAMS_KEY, (Object)stepConfig, (Object)STEP_ID_PARAMS_KEY, (Object)stepId);
            this.stepSchedulerService.scheduleStepOnce(stepId, RUNNER_KEY, JobId.of((String)jobId), EXPORT_STEP_TYPE, (Map<String, Serializable>)jobParams);
            return Optional.empty();
        });
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_PARAMS_KEY);
        String config = (String)request.getJobConfig().getParameters().get(STEP_CONFIG_PARAMS_KEY);
        this.stepSchedulerService.runStep(stepId, EXPORT_STEP_TYPE, () -> this.doExport(config));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StepResult doExport(String config) {
        String exportedFile;
        ConfExportStepConfig exportStepConfig = Jsons.readValue(config, ConfExportStepConfig.class);
        String spaceKey = exportStepConfig.getSpaceKey();
        if (StringUtils.isBlank((String)spaceKey)) {
            return StepResult.failed("Attempted to perform an export, but no space key was found.");
        }
        String fileId = exportStepConfig.getFileId();
        if (StringUtils.isBlank((String)fileId)) {
            return StepResult.failed("Attempted to perform an export, but no file ID was found.");
        }
        String cloudId = exportStepConfig.getCloudId();
        if (StringUtils.isBlank((String)cloudId)) {
            return StepResult.failed("Attempted to perform an export, but no cloud ID was found.");
        }
        this.attachmentService.prepareMigratedAttachmentsForExport(spaceKey, cloudId);
        try {
            exportedFile = this.spaceNoAttachmentsXmlExporter.doExport(spaceKey, fileId).get();
            this.spaceExportPostProcessor.postprocess(Paths.get(exportedFile, new String[0]));
        }
        catch (InterruptedException ex) {
            StepResult stepResult = StepResult.failed(String.format("Export of %s was interrupted", exportStepConfig), ex);
            return stepResult;
        }
        catch (ExecutionException ex) {
            StepResult stepResult = StepResult.failed(String.format("Failed to export %s", exportStepConfig), ex.getCause());
            return stepResult;
        }
        finally {
            this.attachmentService.cleanMigratedAttachmentsAfterExport(spaceKey, cloudId);
        }
        this.exportDirManager.moveExportedFileToShardHome(exportedFile, fileId);
        return StepResult.succeeded("Data export successful", fileId);
    }
}

