/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.planning.BaseStepPlanningEngine;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;

@Singleton
public class ConfSpacePlanningEngine
extends BaseStepPlanningEngine<ConfluenceSpaceTask> {
    ConfSpacePlanningEngine() {
        super(ConfluenceSpaceTask.class, Arrays.asList(Pair.of((Object)((Object)StepType.ATTACHMENT_UPLOAD), (Object)40), Pair.of((Object)((Object)StepType.CONFLUENCE_EXPORT), (Object)20), Pair.of((Object)((Object)StepType.DATA_UPLOAD), (Object)20), Pair.of((Object)((Object)StepType.CONFLUENCE_IMPORT), (Object)20)));
    }

    @Override
    public Step createFirstStep(ConfluenceSpaceTask task) {
        Step step = new Step();
        step.setType(StepType.ATTACHMENT_UPLOAD.name());
        step.setConfig(task.getSpaceKey());
        return step;
    }

    @Override
    public Optional<Step> createNextStep(ConfluenceSpaceTask task, Step currentStep) {
        Step step = new Step();
        Optional<String> result = currentStep.getProgress().getResult();
        StepType stepType = StepType.valueOf(currentStep.getType());
        switch (stepType) {
            case ATTACHMENT_UPLOAD: {
                step.setType(StepType.CONFLUENCE_EXPORT.name());
                String cloudId = task.getPlan().getCloudSite().getCloudId();
                step.setConfig(Jsons.valueAsString(new ConfExportStepConfig(task.getSpaceKey(), UUID.randomUUID().toString(), cloudId)));
                return Optional.of(step);
            }
            case CONFLUENCE_EXPORT: {
                step.setType(StepType.DATA_UPLOAD.name());
                step.setConfig(result.orElseThrow(() -> new IllegalStateException("No result from export step")));
                return Optional.of(step);
            }
            case DATA_UPLOAD: {
                step.setType(StepType.CONFLUENCE_IMPORT.name());
                step.setConfig(result.orElseThrow(() -> new IllegalStateException("No result from data upload step")));
                return Optional.of(step);
            }
            case CONFLUENCE_IMPORT: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown step type " + currentStep.getType());
    }
}

