/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.base.CheckExecutor;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.PreflightCheckProgressDto;
import com.atlassian.migration.agent.dto.PrelightCheckPlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.PlanService;
import com.atlassian.migration.agent.service.check.CheckRegistry;
import com.atlassian.migration.agent.service.check.CheckTransformerService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class PlanDecoratorService {
    private static final Logger log = ContextLoggerFactory.getLogger(PlanDecoratorService.class);
    private final PlanService planService;
    private final CheckTransformerService checkTransformerService;
    private final CheckExecutor checkExecutor;
    private final ExecutorService executorService;
    private final CheckRegistry checkRegistry;

    @Inject
    PlanDecoratorService(PlanService planService, CheckTransformerService checkTransformerService, CheckExecutor checkExecutor, CheckRegistry checkRegistry) {
        this(planService, checkTransformerService, checkExecutor, checkRegistry, Executors.newCachedThreadPool());
    }

    @VisibleForTesting
    PlanDecoratorService(PlanService planService, CheckTransformerService checkTransformerService, CheckExecutor checkExecutor, CheckRegistry checkRegistry, ExecutorService executorService) {
        this.planService = planService;
        this.checkTransformerService = checkTransformerService;
        this.checkExecutor = checkExecutor;
        this.executorService = executorService;
        this.checkRegistry = checkRegistry;
    }

    @PreDestroy
    @VisibleForTesting
    void preDestroy() {
        this.executorService.shutdownNow();
    }

    public PrelightCheckPlanDto getPlan(String planId) {
        PlanDto planDto = this.planService.getPlan(planId);
        return new PrelightCheckPlanDto(planDto, this.getCheckResultDtos(planId));
    }

    public List<PrelightCheckPlanDto> getAllPlans() {
        List<PlanDto> plans = this.planService.getAllPlans();
        if (plans.isEmpty()) {
            return Collections.emptyList();
        }
        return plans.stream().map(planDto -> new PrelightCheckPlanDto((PlanDto)planDto, this.getCheckResultDtos(planDto.getId()))).collect(Collectors.toList());
    }

    public PlanDto createPlan(PlanDto plan) {
        return this.planService.createPlan(plan);
    }

    public PlanDto updatePlan(PlanDto plan) {
        return this.planService.updatePlan(plan);
    }

    public PreflightCheckProgressDto getPlanProgress(String planId) {
        ProgressDto progressDto = this.planService.getPlanProgress(planId);
        return new PreflightCheckProgressDto(progressDto, this.getCheckResultDtos(planId));
    }

    public boolean stop(String planId) {
        return this.planService.stop(planId);
    }

    public boolean planNameExists(String planName) {
        return this.planService.planNameExists(planName);
    }

    public PlanDto verifyAndStart(String planId) {
        PlanDto planDto = this.planService.verifyPlan(planId);
        this.executorService.submit(() -> this.startPreflightChecksAndPoll(planDto));
        return planDto;
    }

    private void startPreflightChecksAndPoll(PlanDto planDto) {
        List<CheckRequest> checkRequests = this.checkTransformerService.getCheckRequests(planDto);
        this.checkExecutor.executeChecks(planDto.getId(), checkRequests);
        while (true) {
            Optional maybeCheckExecutionStatus;
            if (!(maybeCheckExecutionStatus = this.checkExecutor.getStatus(planDto.getId())).isPresent()) {
                this.planService.setCreatedStatus(planDto.getId());
                return;
            }
            CheckExecutionStatus checkExecutionStatus = (CheckExecutionStatus)maybeCheckExecutionStatus.get();
            boolean hasRunningChecks = checkExecutionStatus.statuses.stream().anyMatch(checkStatus -> checkStatus.checkResult == null);
            if (!hasRunningChecks) {
                boolean hasErrors = checkExecutionStatus.statuses.stream().anyMatch(checkStatus -> !checkStatus.checkResult.success && this.checkRegistry.shouldBlockMigration((CheckStatus)checkStatus));
                if (hasErrors) {
                    this.planService.setCreatedStatus(planDto.getId());
                } else {
                    this.planService.startPlan(planDto.getId());
                }
                return;
            }
            this.doSleep(100);
        }
    }

    @VisibleForTesting
    void doSleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            log.debug("Failed to sleep. Sleep was interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private List<CheckResultDto> getCheckResultDtos(String planId) {
        Optional maybeStatus = this.checkExecutor.getStatus(planId);
        return maybeStatus.map(status -> this.checkTransformerService.toCheckResultDtos(status.statuses)).orElse(Collections.emptyList());
    }
}

