/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentCSVDto;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentCSVResponse;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentResponse;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentStatsResponse;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentUpdateRequest;
import com.atlassian.migration.agent.dto.assessment.AppSummaryDto;
import com.atlassian.migration.agent.dto.assessment.AppUsageResponse;
import com.atlassian.migration.agent.entity.AppAssessmentInfo;
import com.atlassian.migration.agent.entity.AppAssessmentUserAttributedStatus;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.analytics.AppAssessmentAnalyticsEventService;
import com.atlassian.migration.agent.service.app.PluginManager;
import com.atlassian.migration.agent.service.impl.AppUsageService;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.atlassian.migration.agent.store.impl.AppAssessmentInfoStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginState;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AppAssessmentService {
    private final MigrationAppAggregatorService appAggregatorService;
    private static final AppAssessmentUserAttributedStatus DEFAULT_USER_ASSESSMENT_STATUS = AppAssessmentUserAttributedStatus.Unassigned;
    private final AppAssessmentInfoStore appInfoStore;
    private final PluginTransactionTemplate ptx;
    private static final Map<String, Function<String, Object>> appPropValuesTransformers = ImmutableMap.of((Object)"migrationStatus", s -> s == null ? DEFAULT_USER_ASSESSMENT_STATUS : AppAssessmentUserAttributedStatus.valueOf(s), (Object)"migrationNotes", str -> str);
    private final PluginManager pluginManager;
    private final AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService;
    private final AppUsageService appUsageService;
    private static final String DEFAULT_NOTES = "";

    @Inject
    public AppAssessmentService(MigrationAppAggregatorService appAggregatorService, PluginManager pluginManager, AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService, AppAssessmentInfoStore appAssessmentInfoStore, PluginTransactionTemplate ptx, AppUsageService appUsageService) {
        this.appAggregatorService = appAggregatorService;
        this.pluginManager = pluginManager;
        this.appAssessmentAnalyticsEventService = appAssessmentAnalyticsEventService;
        this.appInfoStore = appAssessmentInfoStore;
        this.ptx = ptx;
        this.appUsageService = appUsageService;
    }

    public AppAssessmentResponse getPlugins() {
        return new AppAssessmentResponse(this.collectAppInfo());
    }

    public AppAssessmentStatsResponse getPluginStats() {
        Map<AppAssessmentUserAttributedStatus, Long> stats = this.collectAppInfo().stream().collect(Collectors.groupingBy(AppSummaryDto::getMigrationStatus, Collectors.counting()));
        this.createMissing(stats);
        return new AppAssessmentStatsResponse(stats);
    }

    public void updateMigrationStatus(String appKey, AppAssessmentUpdateRequest request) {
        Objects.requireNonNull(request);
        String propName = request.getAppProperty();
        if (!appPropValuesTransformers.containsKey(propName)) {
            throw new IllegalArgumentException(String.format("Unrecognised property name [%s]", propName));
        }
        this.ptx.write(() -> {
            if (this.appInfoStore.getByAppKey(appKey).isPresent()) {
                this.appInfoStore.updateProperty(appKey, propName, this.transformPropertyValue(propName, request.getValue()));
            } else {
                this.appInfoStore.create(this.toAppAssessmentInfo(appKey, request));
            }
        });
        this.appAssessmentAnalyticsEventService.savePropertyChangedEvent(AuthenticatedUserThreadLocal.get(), appKey, propName);
    }

    public AppAssessmentCSVResponse getAppAssessmentCSVData() {
        List<AppAssessmentCSVDto> csvDtos = this.collectAppInfo().stream().map(appSummaryDto -> new AppAssessmentCSVDto((AppSummaryDto)appSummaryDto, this.appUsageService.getAppUsageByPluginKey(appSummaryDto.getKey()))).collect(Collectors.toList());
        return new AppAssessmentCSVResponse(csvDtos);
    }

    public AppUsageResponse getAppUsageStats() {
        return this.appUsageService.getAppUsageStats();
    }

    public String clearAppUsageCache() {
        return this.appUsageService.clearAppUsageCache();
    }

    public static boolean isPluginEnabled(Plugin plugin) {
        return PluginState.ENABLED == plugin.getPluginState();
    }

    private void createMissing(Map<AppAssessmentUserAttributedStatus, Long> stats) {
        Set<AppAssessmentUserAttributedStatus> existing = stats.keySet();
        EnumSet<AppAssessmentUserAttributedStatus> missing = existing.isEmpty() ? EnumSet.allOf(AppAssessmentUserAttributedStatus.class) : EnumSet.complementOf(EnumSet.copyOf(existing));
        stats.putAll(missing.stream().collect(Collectors.toMap(Function.identity(), o -> 0L)));
    }

    private List<AppSummaryDto> collectAppInfo() {
        Map assessedPlugins = this.appInfoStore.getAll().stream().collect(Collectors.toMap(AppAssessmentInfo::getAppKey, Function.identity()));
        List<AppSummaryDto> collect = this.pluginManager.getActualUserInstalledPlugins().parallelStream().map(plugin -> this.buildPluginData((Plugin)plugin, assessedPlugins)).collect(Collectors.toList());
        this.appAssessmentAnalyticsEventService.saveAppsFetchedEvent(collect.stream().map(AppSummaryDto::getKey).collect(Collectors.toList()), AuthenticatedUserThreadLocal.get());
        return collect;
    }

    private AppSummaryDto buildPluginData(Plugin plugin, Map<String, AppAssessmentInfo> assessedPlugins) {
        MigrationAppAggregatorResponse appAggregatorResponse = this.appAggregatorService.getCachedAppData(plugin.getKey());
        return new AppSummaryDto(plugin.getKey(), plugin.getName(), appAggregatorResponse.getIcon(), AppAssessmentService.isPluginEnabled(plugin), appAggregatorResponse.hasCloud(), appAggregatorResponse.getCloudUrl(), this.resolveMigrationStatus(plugin, assessedPlugins), this.resolveMigrationNotes(plugin, assessedPlugins));
    }

    private AppAssessmentUserAttributedStatus resolveMigrationStatus(Plugin plugin, Map<String, AppAssessmentInfo> assessedPlugins) {
        return assessedPlugins.containsKey(plugin.getKey()) ? assessedPlugins.get(plugin.getKey()).getMigrationStatus() : DEFAULT_USER_ASSESSMENT_STATUS;
    }

    private String resolveMigrationNotes(Plugin plugin, Map<String, AppAssessmentInfo> assessedPlugins) {
        return assessedPlugins.containsKey(plugin.getKey()) ? assessedPlugins.get(plugin.getKey()).getMigrationNotes() : DEFAULT_NOTES;
    }

    private Object transformPropertyValue(String propName, String value) {
        return appPropValuesTransformers.get(propName).apply(value);
    }

    private AppAssessmentInfo toAppAssessmentInfo(String appKey, AppAssessmentUpdateRequest request) {
        return new AppAssessmentInfo(appKey, (AppAssessmentUserAttributedStatus)((Object)this.extractIfExists(request, "migrationStatus")), (String)this.extractIfExists(request, "migrationNotes"));
    }

    private Object extractIfExists(AppAssessmentUpdateRequest request, String propName) {
        String maybeValue = request.getAppProperty().equals(propName) ? request.getValue() : null;
        return this.transformPropertyValue(propName, maybeValue);
    }
}

