/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckContext;
import com.atlassian.cmpt.check.base.CheckExecutor;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.ExecutionErrorCodes;
import com.atlassian.migration.agent.entity.CheckExecutionStatus;
import com.atlassian.migration.agent.entity.CheckResultEntity;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistry;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
class AsyncCheckExecutor
implements CheckExecutor,
JobRunner {
    private static final Logger log = ContextLoggerFactory.getLogger(AsyncCheckExecutor.class);
    private static final String CHECK_JOB_RUNNER_ID = "migration-plugin:checks-runner";
    private static final String EXECUTION_ID_KEY = "checkExecutionId";
    private static final String CHECK_TYPE_KEY = "checkType";
    private static final String INPUT_PARAMETER_PREFIX = "inputParameter-";
    private final SchedulerService schedulerService;
    private final CheckResultsService checkResultService;
    private final CheckRegistry checkerRegistry;
    private final PluginTransactionTemplate ptx;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;

    @Inject
    AsyncCheckExecutor(SchedulerService schedulerService, CheckResultsService checkResultService, CheckRegistry checkerRegistry, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this.schedulerService = schedulerService;
        this.checkResultService = checkResultService;
        this.checkerRegistry = checkerRegistry;
        this.ptx = ptx;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
    }

    private static String getExecutionIdFromJobParams(Map<String, Serializable> params) {
        return (String)((Object)params.get(EXECUTION_ID_KEY));
    }

    private static CheckType getCheckTypeFromJobParams(Map<String, Serializable> params) {
        return CheckType.fromString((String)((Object)params.get(CHECK_TYPE_KEY)));
    }

    private static Map<String, Object> getInputParamsFromJobParams(Map<String, Serializable> params) {
        return params.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(INPUT_PARAMETER_PREFIX)).collect(Collectors.toMap(entry -> StringUtils.substringAfter((String)((String)entry.getKey()), (String)INPUT_PARAMETER_PREFIX), Map.Entry::getValue));
    }

    private static Map<String, Serializable> generateJobParameters(String executionId, CheckType checkType, @Nullable Map<String, Object> inputParameters) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(EXECUTION_ID_KEY, (Serializable)((Object)executionId));
        params.put(CHECK_TYPE_KEY, (Serializable)((Object)checkType.value()));
        if (inputParameters != null) {
            inputParameters.forEach((key, value) -> params.put(INPUT_PARAMETER_PREFIX + key, (Serializable)value));
        }
        return params;
    }

    @PostConstruct
    public void postConstruct() {
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)CHECK_JOB_RUNNER_ID), (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)CHECK_JOB_RUNNER_ID));
    }

    public Optional<com.atlassian.cmpt.check.base.CheckExecutionStatus> getStatus(String executionId) {
        List<CheckResultEntity> results = this.checkResultService.getByExecutionId(executionId);
        if (CollectionUtils.isEmpty(results)) {
            return Optional.empty();
        }
        List statuses = results.stream().map(this::convertToCheckStatus).collect(Collectors.toList());
        return Optional.of(new com.atlassian.cmpt.check.base.CheckExecutionStatus(executionId, statuses));
    }

    public void executeChecks(String executionId, List<CheckRequest> checkRequests) {
        checkRequests.forEach(checkRequest -> this.scheduleCheck(executionId, (CheckRequest)checkRequest));
    }

    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Instant startTime = Instant.now();
        Map jobParams = jobRunnerRequest.getJobConfig().getParameters();
        String executionId = AsyncCheckExecutor.getExecutionIdFromJobParams(jobParams);
        CheckType checkType = AsyncCheckExecutor.getCheckTypeFromJobParams(jobParams);
        try {
            CheckResult checkResult = this.executeChecker(jobParams, executionId);
            log.info("Finishing execution of check {}. Success: {}", (Object)checkType, (Object)checkResult.success);
            this.saveAnalyticsEventAfterCheckWasExecuted(startTime, checkType, checkResult);
            return JobRunnerResponse.success((String)"ok");
        }
        catch (Exception e) {
            log.error("Couldn't execute check of type {} with id {}", new Object[]{checkType.value(), executionId, e});
            CheckResult failedCheckResult = Checker.buildCheckResultWithExecutionError((int)ExecutionErrorCodes.GENERIC.getErrorCode());
            this.checkResultService.saveCheckResult(executionId, checkType, failedCheckResult);
            this.saveAnalyticsEventAfterCheckWasExecuted(startTime, checkType, failedCheckResult);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    private void saveAnalyticsEventAfterCheckWasExecuted(Instant startTime, CheckType checkType, CheckResult checkResult) {
        long totalTime = ChronoUnit.MILLIS.between(startTime, Instant.now());
        this.analyticsEventService.saveAnalyticsEvent(() -> this.checkerRegistry.getAnalyticsEventModel(checkType, checkResult, totalTime));
    }

    private CheckResult executeChecker(Map<String, Serializable> jobParams, String executionId) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            CheckType checkType = AsyncCheckExecutor.getCheckTypeFromJobParams(jobParams);
            log.info("Starting execution of check {}", (Object)checkType);
            Map<String, Object> inputParameters = AsyncCheckExecutor.getInputParamsFromJobParams(jobParams);
            CheckContextProvider<CheckContext> contextProvider = this.checkerRegistry.getCheckContextProvider(checkType);
            CheckContext checkContext = (CheckContext)contextProvider.apply((CheckContext)inputParameters);
            Checker<CheckContext> checker = this.checkerRegistry.getChecker(checkType);
            CheckResult checkResult = checker.check(checkContext);
            this.checkResultService.saveCheckResult(executionId, checkType, checkResult);
            return checkResult;
        });
    }

    private void scheduleCheck(String executionId, CheckRequest request) {
        CheckType checkType = CheckType.fromString(request.checkType);
        boolean isRunning = this.ptx.write(() -> {
            CheckResultEntity checkResultEntity = this.checkResultService.getOrCreate(executionId, checkType);
            if (checkResultEntity.getStatus() == CheckExecutionStatus.RUNNING) {
                log.info("Skipping check for executionID = {} and checkType = {} because status already is RUNNING.", (Object)executionId, (Object)checkType);
                return true;
            }
            this.checkResultService.updateStatusToRunning(checkResultEntity);
            return false;
        });
        if (!isRunning) {
            this.scheduleAsyncJob(executionId, checkType, request);
        }
    }

    private void scheduleAsyncJob(String executionId, CheckType checkType, CheckRequest request) {
        try {
            Map<String, Serializable> jobParams = AsyncCheckExecutor.generateJobParameters(executionId, checkType, request.parameters);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)CHECK_JOB_RUNNER_ID)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null)).withParameters(jobParams);
            JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            log.info("Scheduled check {}, jobId = {}.", (Object)checkType, (Object)jobId);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(String.format("Failed to schedule check %s", new Object[]{checkType}), e);
        }
    }

    private CheckStatus convertToCheckStatus(CheckResultEntity entity) {
        CheckResult result = entity.getStatus() == CheckExecutionStatus.RUNNING ? null : (CheckResult)this.checkResultService.getCheckResult(entity).orElse(null);
        Long lastExecutionTime = entity.getLastExecutionTime() != null ? Long.valueOf(entity.getLastExecutionTime().toEpochMilli()) : null;
        return new CheckStatus(entity.getCheckType(), result, lastExecutionTime);
    }
}

