/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.okhttp;

import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.DefaultHttpServiceErrorHandler;
import com.atlassian.migration.agent.okhttp.HttpServiceErrorHandler;
import com.atlassian.migration.agent.okhttp.IOHttpException;
import com.atlassian.migration.agent.okhttp.ResponseParsingHttpException;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.codehaus.jackson.type.TypeReference;

public class HttpService {
    private static final HttpServiceErrorHandler DEFAULT_ERROR_HANDLER = new DefaultHttpServiceErrorHandler();
    private final Supplier<OkHttpClient> clientSupplier;
    private final HttpServiceErrorHandler errorHandler;

    public HttpService(Supplier<OkHttpClient> httpClientSupplier) {
        this.clientSupplier = httpClientSupplier;
        this.errorHandler = DEFAULT_ERROR_HANDLER;
    }

    public HttpService(Supplier<OkHttpClient> httpClientSupplier, HttpServiceErrorHandler errorHandler) {
        this.clientSupplier = httpClientSupplier;
        this.errorHandler = errorHandler;
    }

    public <T> T callJson(Request request, TypeReference<T> bodyType) {
        return (T)this.call(request, body -> {
            try {
                return Jsons.OBJECT_MAPPER.readValue(body.charStream(), bodyType);
            }
            catch (IOException e) {
                throw new ResponseParsingHttpException(String.format("Failed to deserialize response body to %s", bodyType.getType().getTypeName()), e);
            }
        });
    }

    public void call(Request request) {
        try (ResponseBody body = null;){
            body = this.callImpl(request).body();
        }
    }

    public <T> T call(Request request, Function<ResponseBody, T> bodyMapper) {
        Response response = this.callImpl(request);
        ResponseBody body = response.body();
        if (body == null) {
            throw new ResponseParsingHttpException("No body in response");
        }
        try {
            T t = bodyMapper.apply(body);
            return t;
        }
        catch (RuntimeException e) {
            throw new ResponseParsingHttpException("Failed to parse response body", e);
        }
        finally {
            body.close();
        }
    }

    private Response callImpl(Request request) {
        Response response;
        try {
            response = this.clientSupplier.get().newCall(request).execute();
        }
        catch (IOException e) {
            throw new IOHttpException("An IO exception occurred when communicating with a downstream service", e);
        }
        if (!response.isSuccessful()) {
            this.errorHandler.accept(response);
        }
        return response;
    }
}

