/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.migration.agent.media.CreateFileOptions;
import com.atlassian.migration.agent.media.Entity;
import com.atlassian.migration.agent.media.Etag;
import com.atlassian.migration.agent.media.MediaApiClient;
import com.atlassian.migration.agent.media.MediaFileUploader;
import com.atlassian.migration.agent.media.MediaUploadException;
import com.atlassian.migration.agent.media.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.commons.collections.CollectionUtils;

public class DefaultMediaFileUploader
implements MediaFileUploader {
    private static final int CHUNK_BATCH_SIZE = 100;
    private static final int CHUNK_SIZE = 0x400000;
    private final MediaApiClient mediaApiClient;

    DefaultMediaFileUploader(MediaApiClient mediaApiClient) {
        this.mediaApiClient = Objects.requireNonNull(mediaApiClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public String upload(File file, MediaFileUploader.Tracker tracker) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(tracker);
        try (FileInputStream is = new FileInputStream(file);){
            String string = this.upload(is, null, tracker);
            return string;
        }
        catch (IOException e) {
            throw new MediaUploadException("Could not read file", e);
        }
    }

    @Override
    @Nonnull
    public String upload(@WillNotClose InputStream is, @Nullable String name, MediaFileUploader.Tracker tracker) {
        List<Etag> etags;
        Upload upload = this.mediaApiClient.createUpload().orElseThrow(() -> new MediaUploadException("Could not acquire upload"));
        int index = 0;
        byte[] buffer = new byte[0x400000];
        while (!CollectionUtils.isEmpty(etags = this.sendChunks(is, buffer, tracker))) {
            this.mediaApiClient.updateUpload(upload.getId(), index, etags);
            index += etags.size();
        }
        Entity entity = this.mediaApiClient.createFileFromUpload(upload.getId(), name, null, CreateFileOptions.builder().build());
        return entity.getId();
    }

    private List<Etag> sendChunks(@WillNotClose InputStream is, byte[] buffer, MediaFileUploader.Tracker tracker) {
        ArrayList<Etag> etags = new ArrayList<Etag>();
        try {
            int bytesRead;
            while ((bytesRead = DefaultMediaFileUploader.getChunk(is, buffer)) > 0) {
                Etag etag = this.mediaApiClient.uploadChunk(ByteBuffer.wrap(buffer, 0, bytesRead));
                tracker.track(etag.getLength());
                etags.add(etag);
                if (etags.size() < 100) continue;
                return etags;
            }
        }
        catch (IOException e) {
            throw new MediaUploadException("Unexpected exception sending chunks to media", e);
        }
        return etags;
    }

    private static int getChunk(@WillNotClose InputStream is, byte[] buffer) throws IOException {
        int bytesRead;
        int got;
        for (bytesRead = 0; bytesRead < 0x400000; bytesRead += got) {
            got = is.read(buffer, bytesRead, 0x400000 - bytesRead);
            if (got != -1) continue;
            return bytesRead == 0 ? -1 : bytesRead;
        }
        return bytesRead;
    }
}

