package com.atlassian.messagequeue;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nullable;

/**
 * Thrown on message runner invocation when a message with the given key cannot be found.
 * @since 1.0
 */
@PublicApi
public class MessageRunnerNotRegisteredException extends RuntimeException {
    /**
     * @param key message runner key
     */
    public MessageRunnerNotRegisteredException(@Nullable MessageRunnerKey key) {
        super("No message runner found for key: " + key);
    }
}
