package com.atlassian.messagequeue;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nullable;

/**
 * Thrown on message runner invocation when a payload that is too large is passed.
 * @since 1.0
 */
@PublicApi
public class MessagePayloadSizeExceededException extends RuntimeException {
    /**
     * @param key message runner key
     * @param maxSize max size
     */
    public MessagePayloadSizeExceededException(@Nullable MessageRunnerKey key, long maxSize) {
        super("Message runner with key: '" + key + "' invoked with payload that is above the max size of " + maxSize);
    }
}
