/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.api.entity;

public enum ArtifactType {
    METADATA("meta.json"),
    DOCUMENT_PDF("document.pdf"),
    DOCUMENT_TXT("document.txt"),
    THUMBNAIL("thumb.jpg"),
    THUMBNAIL_LARGE("thumb_large.jpg"),
    THUMBNAIL_120("thumb_120.jpg"),
    THUMBNAIL_320("thumb_320.jpg"),
    IMAGE("image.jpg"),
    AUDIO("audio.mp3"),
    VIDEO_640("video_640.mp4"),
    VIDEO_1280("video_1280.mp4"),
    POSTER_640("poster_640.jpg"),
    POSTER_1280("poster_1280.jpg");

    private final String fileName;

    private ArtifactType(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static ArtifactType fromFileName(String fileName) {
        for (ArtifactType type : ArtifactType.values()) {
            if (!type.getFileName().equals(fileName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Cannot find artifact type with file name:" + fileName);
    }
}

