/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.maven.plugins.jgitflow.MavenJGitFlowConfiguration;
import com.atlassian.maven.plugins.jgitflow.manager.MavenJGitFlowConfigManager;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jgit.api.Git;

public class DefaultMavenJGitFlowConfigManager
implements MavenJGitFlowConfigManager {
    private MavenJGitFlowConfiguration config;

    @Override
    public MavenJGitFlowConfiguration getConfiguration(Git git) throws IOException {
        if (null == this.config) {
            File configFile = new File(git.getRepository().getDirectory(), ".maven-jgitflow");
            this.config = this.loadConfiguration(configFile);
        }
        return this.config;
    }

    @Override
    public void saveConfiguration(MavenJGitFlowConfiguration newConfig, Git git) throws IOException {
        File configFile = new File(git.getRepository().getDirectory(), ".maven-jgitflow");
        if (!configFile.exists()) {
            Files.write((byte[])"{}".getBytes(), (File)configFile);
        }
        Gson gson = this.createGson();
        String json = gson.toJson((Object)newConfig);
        Files.write((byte[])json.getBytes(), (File)configFile);
        this.config = newConfig;
    }

    private Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson;
    }

    private MavenJGitFlowConfiguration loadConfiguration(File configFile) {
        MavenJGitFlowConfiguration loadedConfig = null;
        try {
            String configJson;
            if (!configFile.exists()) {
                Files.write((byte[])"{}".getBytes(), (File)configFile);
            }
            if (Strings.isNullOrEmpty((String)(configJson = FileUtils.fileRead((File)configFile)))) {
                Files.write((byte[])"{}".getBytes(), (File)configFile);
                configJson = "{}";
            }
            Gson gson = this.createGson();
            loadedConfig = (MavenJGitFlowConfiguration)gson.fromJson(configJson, MavenJGitFlowConfiguration.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            loadedConfig = null;
        }
        return loadedConfig;
    }
}

