/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.maven.plugins.jgitflow.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="release-start", aggregator=true)
public class ReleaseStartMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(defaultValue="false", property="allowSnapshots")
    private boolean allowSnapshots = false;
    @Parameter(property="releaseVersion")
    private String releaseVersion;
    @Parameter(property="releaseBranchVersionSuffix", defaultValue="")
    private String releaseBranchVersionSuffix;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="pushReleases")
    private boolean pushReleases = false;
    @Component(hint="release")
    FlowReleaseManager releaseManager;
    @Parameter(property="startCommit", defaultValue="")
    private String startCommit;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setAutoVersionSubmodules(this.autoVersionSubmodules).setInteractive(this.getSettings().isInteractiveMode()).setDefaultReleaseVersion(this.releaseVersion).setReleaseBranchVersionSuffix(this.releaseBranchVersionSuffix).setAllowSnapshots(this.allowSnapshots).setUpdateDependencies(this.updateDependencies).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setPushReleases(this.pushReleases).setStartCommit(this.startCommit).setAllowRemote(this.isRemoteAllowed()).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.start(ctx, this.getReactorProjects(), this.session);
        }
        catch (JGitFlowReleaseException e) {
            throw new MojoExecutionException("Error starting release: " + e.getMessage(), (Exception)e);
        }
    }
}

