/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jline.ANSIBuffer;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

public class PrettyPrompter
implements Prompter {
    public static final int OFF = 0;
    public static final int BOLD = 1;
    public static final int UNDERSCORE = 4;
    public static final int BLINK = 5;
    public static final int REVERSE = 7;
    public static final int CONCEALED = 8;
    public static final int FG_BLACK = 30;
    public static final int FG_RED = 31;
    public static final int FG_GREEN = 32;
    public static final int FG_YELLOW = 33;
    public static final int FG_BLUE = 34;
    public static final int FG_MAGENTA = 35;
    public static final int FG_CYAN = 36;
    public static final int FG_WHITE = 37;
    public static final char ESC = '\u001b';
    private OutputHandler outputHandler;
    private InputHandler inputHandler;
    private boolean useAnsiColor;

    public PrettyPrompter() {
        String mavencolor = System.getenv("MAVEN_COLOR");
        this.useAnsiColor = mavencolor != null && !mavencolor.equals("") ? Boolean.parseBoolean(mavencolor) : false;
    }

    public String promptNotBlank(String message) throws PrompterException {
        return this.promptNotBlank(message, null);
    }

    public String promptNotBlank(String message, String defaultValue) throws PrompterException {
        String value = StringUtils.isBlank((String)defaultValue) ? this.prompt(this.requiredMessage(message)) : this.prompt(message, defaultValue);
        if (StringUtils.isBlank((String)value)) {
            value = this.promptNotBlank(message, defaultValue);
        }
        return value;
    }

    public String requiredMessage(String message) {
        String formattedMessage = message;
        if (this.useAnsiColor) {
            ANSIBuffer ansiBuffer = new ANSIBuffer();
            ansiBuffer.append(ANSIBuffer.ANSICodes.attrib((int)1)).append(ANSIBuffer.ANSICodes.attrib((int)31)).append(message).append(ANSIBuffer.ANSICodes.attrib((int)0));
            formattedMessage = ansiBuffer.toString();
        }
        return formattedMessage;
    }

    public String prompt(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
        try {
            return StringUtils.trim((String)this.inputHandler.readLine());
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        try {
            this.writePrompt(this.formatMessage(message, null, defaultReply));
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
        try {
            String line = this.inputHandler.readLine();
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            return StringUtils.trim((String)line);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            try {
                this.writePrompt(formattedMessage);
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present prompt", (Throwable)e);
            }
            try {
                line = this.inputHandler.readLine();
            }
            catch (IOException e) {
                throw new PrompterException("Failed to read user response", (Throwable)e);
            }
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            if (line == null || possibleValues.contains(line)) continue;
            try {
                String invalid = "Invalid selection.";
                if (this.useAnsiColor) {
                    ANSIBuffer ansiBuffer = new ANSIBuffer();
                    ansiBuffer.append(ANSIBuffer.ANSICodes.attrib((int)31)).append(ANSIBuffer.ANSICodes.attrib((int)1)).append("Invalid selection.").append(ANSIBuffer.ANSICodes.attrib((int)0));
                    invalid = ansiBuffer.toString();
                }
                this.outputHandler.writeLine(invalid);
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", (Throwable)e);
            }
        } while (line == null || !possibleValues.contains(line));
        return StringUtils.trim((String)line);
    }

    public String promptNumberedList(String message, List<String> possibleValues) throws PrompterException {
        return this.promptNumberedList(message, possibleValues, null);
    }

    public String promptNumberedList(String message, List<String> possibleValues, String defaultValue) throws PrompterException {
        MessageAndAnswers ma = this.formatNumberedMessage(message, possibleValues, defaultValue);
        String answer = this.prompt(ma.message, ma.answers, ma.defaultAnswer);
        int answerInt = Integer.parseInt(answer);
        return possibleValues.get(answerInt - 1);
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String promptForPassword(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
        try {
            return this.inputHandler.readPassword();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    protected String formatMessage(String message, List possibleValues, String defaultReply) {
        if (this.useAnsiColor) {
            return this.formatAnsiMessage(message, possibleValues, defaultReply);
        }
        return this.formatPlainMessage(message, possibleValues, defaultReply);
    }

    private MessageAndAnswers formatNumberedMessage(String message, List<String> possibleValues, String defaultValue) {
        if (this.useAnsiColor) {
            return this.formatNumberedAnsiMessage(message, possibleValues, defaultValue);
        }
        return this.formatNumberedPlainMessage(message, possibleValues, defaultValue);
    }

    private String formatAnsiMessage(String message, List possibleValues, String defaultReply) {
        ANSIBuffer formatted = new ANSIBuffer();
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = (String)it.next();
                formatted.attrib(possibleValue, 1);
                if (!it.hasNext()) continue;
                formatted.append("/");
            }
            formatted.append(")");
        }
        if (defaultReply != null) {
            formatted.append(ANSIBuffer.ANSICodes.attrib((int)32)).append(ANSIBuffer.ANSICodes.attrib((int)1)).append(" [").append(defaultReply).append("]").append(ANSIBuffer.ANSICodes.attrib((int)0));
        }
        return formatted.toString();
    }

    private MessageAndAnswers formatNumberedAnsiMessage(String message, List<String> possibleValues, String defaultValue) {
        ANSIBuffer formatted = new ANSIBuffer();
        formatted.bold(message).append("\n");
        ArrayList<String> answers = new ArrayList<String>();
        String defaultAnswer = "1";
        int counter = 1;
        for (String val : possibleValues) {
            String answer = String.valueOf(counter);
            if (val.equals(defaultValue)) {
                formatted.bold(answer);
                defaultAnswer = answer;
            } else {
                formatted.append(answer);
            }
            if (counter < 10) {
                formatted.append(":  ");
            } else {
                formatted.append(": ");
            }
            if (val.equals(defaultValue)) {
                formatted.bold(val).append("\n");
            } else {
                formatted.append(val).append("\n");
            }
            answers.add(answer);
            ++counter;
        }
        formatted.bold("Choose a number");
        return new MessageAndAnswers(formatted.toString(), answers, defaultAnswer);
    }

    private String formatPlainMessage(String message, List possibleValues, String defaultReply) {
        StringBuffer formatted = new StringBuffer(message.length() * 2);
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = (String)it.next();
                formatted.append(possibleValue);
                if (!it.hasNext()) continue;
                formatted.append('/');
            }
            formatted.append(')');
        }
        if (defaultReply != null) {
            formatted.append(" [").append(defaultReply).append("]");
        }
        return formatted.toString();
    }

    private MessageAndAnswers formatNumberedPlainMessage(String message, List<String> possibleValues, String defaultValue) {
        StringBuffer formatted = new StringBuffer();
        formatted.append(message).append("\n");
        ArrayList<String> answers = new ArrayList<String>();
        int counter = 1;
        String defaultAnswer = "1";
        for (String val : possibleValues) {
            String answer = String.valueOf(counter);
            formatted.append(answer);
            if (val.equals(defaultValue)) {
                defaultAnswer = answer;
            }
            if (counter < 10) {
                formatted.append(":  ");
            } else {
                formatted.append(": ");
            }
            formatted.append(val).append("\n");
            answers.add(answer);
            ++counter;
        }
        formatted.append("Choose a number");
        return new MessageAndAnswers(formatted.toString(), answers, defaultAnswer);
    }

    private void writePrompt(String message) throws IOException {
        this.outputHandler.write(message + ": ");
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
    }

    private class MessageAndAnswers {
        private final String message;
        private final List<String> answers;
        private final String defaultAnswer;

        private MessageAndAnswers(String message, List<String> answers, String defaultAnswer) {
            this.message = message;
            this.answers = answers;
            this.defaultAnswer = defaultAnswer;
        }
    }
}

