/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.maven.plugins.jgitflow.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="feature-start", aggregator=true)
public class FeatureStartMojo
extends AbstractJGitFlowMojo {
    @Parameter(property="featureName")
    private String featureName;
    @Parameter(defaultValue="false", property="enableFeatureVersions")
    private boolean enableFeatureVersions = false;
    @Parameter(defaultValue="false", property="pushFeatures")
    private boolean pushFeatures = false;
    @Parameter(property="startCommit", defaultValue="")
    private String startCommit;
    @Component(hint="feature")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setDefaultFeatureName(this.featureName).setEnableFeatureVersions(this.enableFeatureVersions).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setPushFeatures(this.pushFeatures).setStartCommit(this.startCommit).setAllowRemote(this.isRemoteAllowed()).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.start(ctx, this.getReactorProjects(), this.session);
        }
        catch (JGitFlowReleaseException e) {
            throw new MojoExecutionException("Error starting feature: " + e.getMessage(), (Exception)e);
        }
    }
}

